/*
 * Selfhtml-specific scripts
 */
jQuery( function( $ ) {
	/* top - Navigation */
	$('#p-SELFHTML').appendTo('#mw-head').removeClass().attr('id', 'selfhtml-navigation');
	$('#selfhtml-navigation h5').text('SELFHTML');

	/* Container für Inhaltsnavigation */
	$('#p-personal').after("<div id='navigation-container'></div>");
	$('#left-navigation').appendTo('#navigation-container');
	$('#right-navigation').appendTo('#navigation-container');
	
	/* Doppelpunkt in Überschriften und Brotkrümel*/
	$('#firstHeading > span:contains(":"), .subpages > a:contains(":")').html(function (index, html) {
		return '<span class="namespace">' + html.replace(':',':</span>');
	});
	
		
	/* Zusammenfassungszeile */
	resizeSummary = (function() {
		$('#wpSummary').css({
			float: 'right', 
			width: ($('#mw-content-text').width() - $('#wpSummaryLabel').width() - 15) +'px'
		});
	});
	resizeSummary();
	$(window).resize(function() {
		resizeSummary();
	});
    
	/* spitze Klammern bei Suche entfernen */
	$('#searchform, #search, #clonesearchform').submit(function (event) {
		$("#searchInput, #searchText, #clonesearchInput").val(function (index, value) {
			var k = 0;
			if (value.match(/<\w+>/))
				k = 2;
			if (value.match(/<\w+ \/>/))
				k = 4;
			if (k != 0) {
				var $this = $(this);
				var pos = $this.position();
				$this.after($("<div id='searchform-after'>")
						.text("Die spitzen Klammern gehören nicht zum Element.")
						.css('top', pos.top + $this.outerHeight()));
				return value.substr(1, value.length - k);
			}
			// event.preventDefault();
			return value;
	    });
	});
	
	/* 2. Suchbutton umbenennen */
	$('#mw-search-top-table input[type=submit]').attr('value','Volltextsuche');
    
	/** neue Startseite **/
	if (document.URL.indexOf('Startseite') > 0 || 
      location.pathname == "/" )   {

		// Überschrift in Startseite ausblenden 

		$('#firstHeading').css('display', 'none');
		$('#content').css('border-top', 'none');

		var searchform = $('#searchform'),
				newsearchform = searchform.clone(true).attr('id', 'clonesearchform');

		$('h1 + .threecol').after(newsearchform);

		$('#clonesearchform *').each(function(){
			var $this = $(this);
			if ($this.attr('id')) {
				$this.attr('id', 'clone' + $this.attr('id'));
			}
		});

		$('#clonesearchInput').attr('placeholder', 'im Wiki suchen');

		$('#clonesearchButton').val('Zeige Wiki-Seite');
		$('#clonemw-searchButton').val('Volltextsuche');
	}
	
	$('#clonesearchform > div').append('<p><a href="https://forum.selfhtml.org/self/new?tags%5B%5D=frage+zum+wiki&cf_thread%5Bmessage%5D%5Bsubject%5D=Frage+zum+Wiki">Frage im SELFHTML-Forum stellen‽</a></p>');

	// Logo klonen für Handy-Ansicht
	var logo = $('#p-logo'),
	newlogo = logo.clone(true).attr('id', 'clone-logo');

	$('#p-personal').after(newlogo);
	
});

function importScript() {}
