<?php
/**
 * Skin file for skin Selfhtml.
 *
 * @file
 * @ingroup Skins
 */

require_once( dirname( __FILE__ ) . '/../Vector/Vector.php' );

/**
 * SkinTemplate class for Selfhtml skin
 * @ingroup Skins
 */
class SkinSelfhtml extends SkinVector {
	var $skinname = 'selfhtml', $stylename = 'selfhtml';
	var $template = 'SelfhtmlTemplate';

	function initPage( OutputPage $out ) {
		parent::initPage( $out );

		// unset($out->mModuleScripts[array_search('skins.vector', $out->mModuleScripts)]);
		$out->addModules( 'skins.selfhtml.js' );

		$out->addHeadItem( 'responsiveself', '<meta name="viewport" content="width=device-width, initial-scale=1" />' . "\n");
	}

	/**
	 * @param $out OutputPage object
	 */
	function setupSkinUserCss( OutputPage $out ) {
		$GLOBALS['wgHooks']['SkinVectorStyleModules'][] = function ($dummy, &$styles) {
			unset($styles[array_search('skins.vector.styles', $styles)]);
		};

		parent::setupSkinUserCss( $out );
		$out->addModuleStyles( 'skins.selfhtml' );
	}
}

class SelfhtmlTemplate extends VectorTemplate {
	public function execute() {
		$this->data['content_navigation']['views'] = array_merge(
			$this->data['content_navigation']['views'],
			$this->data['content_navigation']['actions']);
		$this->data['content_navigation']['actions'] = array();
		parent::execute();
	}
}
