<?php

namespace SMW\MediaWiki\Specials\Admin;

use SMW\ApplicationFactory;
use SMW\MediaWiki\Renderer\HtmlFormRenderer;
use Onoi\MessageReporter\MessageReporterFactory;
use SMW\SQLStore\Installer;
use SMW\Message;
use SMW\Store;
use Html;
use WebRequest;

/**
 * @license GNU GPL v2+
 * @since   2.5
 *
 * @author mwjames
 */
class TableSchemaTaskHandler extends TaskHandler {

	/**
	 * @var Store
	 */
	private $store;

	/**
	 * @var HtmlFormRenderer
	 */
	private $htmlFormRenderer;

	/**
	 * @var OutputFormatter
	 */
	private $outputFormatter;

	/**
	 * @since 2.5
	 *
	 * @param Store $store
	 * @param HtmlFormRenderer $htmlFormRenderer
	 * @param OutputFormatter $outputFormatter
	 */
	public function __construct( Store $store, HtmlFormRenderer $htmlFormRenderer, OutputFormatter $outputFormatter ) {
		$this->store = $store;
		$this->htmlFormRenderer = $htmlFormRenderer;
		$this->outputFormatter = $outputFormatter;
	}

	/**
	 * @since 2.5
	 *
	 * {@inheritDoc}
	 */
	public function isTaskFor( $task ) {
		return $task === 'updatetables';
	}

	/**
	 * @since 2.5
	 *
	 * {@inheritDoc}
	 */
	public function getHtml() {

		$this->htmlFormRenderer
			->setName( 'buildtables' )
			->setMethod( 'get' )
			->addHiddenField( 'action', 'updatetables' )
			->addHeader( 'h2', $this->getMessageAsString( 'smw-admin-db' ) )
			->addParagraph( $this->getMessageAsString( 'smw-admin-dbdocu' ) );

		if ( $this->isEnabledFeature( SMW_ADM_SETUP ) ) {
			$this->htmlFormRenderer
				->addHiddenField( 'udsure', 'yes' )
				->addSubmitButton(
					$this->getMessageAsString( 'smw-admin-dbbutton' ),
					array(
						'class' => ''
					)
				);
		} else {
			$this->htmlFormRenderer
				->addParagraph( $this->getMessageAsString( 'smw-admin-feature-disabled' ) );
		}

		return Html::rawElement( 'div', array(), $this->htmlFormRenderer->getForm() );
	}

	/**
	 * @since 2.5
	 *
	 * {@inheritDoc}
	 */
	public function handleRequest( WebRequest $webRequest ) {

		if ( !$this->isEnabledFeature( SMW_ADM_SETUP ) ) {
			return;
		}

		$messageReporter = MessageReporterFactory::getInstance()->newObservableMessageReporter();
		$messageReporter->registerReporterCallback( array( $this, 'reportMessage' ) );

		$this->outputFormatter->setPageTitle( $this->getMessageAsString( 'smw-admin-db' ) );
		$this->outputFormatter->addParentLink();

		$this->store->getOptions()->set(
			Installer::OPT_MESSAGEREPORTER,
			$messageReporter
		);

		$this->outputFormatter->addHTML( Html::rawElement( 'p', array(), $this->getMessageAsString( 'smw-admin-permissionswarn' ) ) );

		$this->outputFormatter->addHTML( '<pre>' );

		// Output is generated by the injected 'installer.messagereporter'
		$result = $this->store->setup();

		$this->outputFormatter->addHTML( '</pre>' );

		if ( $result === true && $webRequest->getText( 'udsure' ) == 'yes' ) {
			$this->outputFormatter->addWikiText( '<p><b>' . $this->getMessageAsString( 'smw-admin-setupsuccess' ) . "</b></p>" );
		}
	}

	/**
	 * @since 2.5
	 *
	 * @param string $message
	 */
	public function reportMessage( $message ) {
		$this->outputFormatter->addHTML( $message );
	}

}
