<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 * @ingroup SMWLanguage
 */
// @codingStandardsIgnoreFile

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'Ask' => array( 'Ask' ),
	'Browse' => array( 'Browse' ),
	'ExportRDF' => array( 'ExportRDF' ),
	'PageProperty' => array( 'PageProperty' ),
	'Properties' => array( 'Properties' ),
	'Concepts' => array( 'Concepts' ),
	'SMWAdmin' => array( 'SemanticMediaWiki', 'SMWAdmin' ),
	'SearchByProperty' => array( 'SearchByProperty' ),
	'ProcessingErrorList' => array( 'ProcessingErrorList' ),
	'PropertyLabelSimilarity' => array( 'PropertyLabelSimilarity' ),
	'SemanticStatistics' => array( 'SemanticStatistics' ),
	'Types' => array( 'Types' ),
	'URIResolver' => array( 'URIResolver' ),
	'UnusedProperties' => array( 'UnusedProperties' ),
	'WantedProperties' => array( 'WantedProperties' ),
	'DeferredRequestDispatcher' => array( 'DeferredRequestDispatcher' ),
);

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = array(
	'Ask' => array( 'Vra' ),
	'Properties' => array( 'Eienskappe' ),
	'Concepts' => array( 'Konsepte' ),
	'Types' => array( 'Tipes' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'Ask' => array( 'سؤال' ),
	'Browse' => array( 'تصفح' ),
	'ExportRDF' => array( 'تصدير_RDF' ),
	'PageProperty' => array( 'صفحة_خصيصة' ),
	'Properties' => array( 'خصائص' ),
	'Concepts' => array( 'مفاهيم' ),
	'SMWAdmin' => array( 'إدارة_سمو', 'إدارة_ميدياويكي_دلالية' ),
	'SearchByProperty' => array( 'بحث_بالخصيصة' ),
	'SemanticStatistics' => array( 'إحصاءات_دلاليّة' ),
	'Types' => array( 'أنواع' ),
	'URIResolver' => array( 'حال_URI' ),
	'UnusedProperties' => array( 'خصائص_غير_مستخدمة' ),
	'WantedProperties' => array( 'خصائص_مطلوبة' ),
);

/** Aramaic (ܐܪܡܝܐ) */
$specialPageAliases['arc'] = array(
	'Ask' => array( 'ܫܐܠ' ),
	'Browse' => array( 'ܦܐܬ' ),
	'PageProperty' => array( 'ܦܐܬܐ_ܕܕܝܠܝܘ̈ܬܐ' ),
	'Properties' => array( 'ܕܝܠܝܘܬ̈ܐ' ),
	'SearchByProperty' => array( 'ܒܨܝ_ܒܝܕ_ܕܝܠܝܘ̈ܬܐ' ),
	'Types' => array( 'ܐܕ̈ܫܐ' ),
	'UnusedProperties' => array( 'ܕܝܠܝܘ̈ܬܐ_ܠܐ_ܦܠܝܚ̈ܬܐ' ),
	'WantedProperties' => array( 'ܕܝܠܝܘ̈ܬܐ_ܣܢܝܩ̈ܬܐ' ),
);

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'Ask' => array( 'سؤال' ),
	'Browse' => array( 'براوز' ),
	'ExportRDF' => array( 'تصدير_RDF' ),
	'PageProperty' => array( 'خاصية_الصفحه' ),
	'Properties' => array( 'خصايص' ),
	'Concepts' => array( 'مبادئ' ),
	'SMWAdmin' => array( 'ادارى_SMW' ),
	'SearchByProperty' => array( 'دوّر_بالخاصيه' ),
	'SemanticStatistics' => array( 'إحصائيات_سيمانتيك' ),
	'Types' => array( 'انواع' ),
	'URIResolver' => array( 'محلل_يو_ار_اى' ),
	'UnusedProperties' => array( 'خصايص_مش_مستعمله' ),
	'WantedProperties' => array( 'خصايص_مطلوبه' ),
);

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = array(
	'Ask' => array( 'সোধক' ),
	'Browse' => array( 'ব্ৰাউজ' ),
	'ExportRDF' => array( 'RDF_ৰপ্তানি' ),
	'Types' => array( 'প্ৰকাৰসমূহ' ),
);

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = array(
	'Ask' => array( 'سوال_و_سوج_ئان' ),
	'Browse' => array( 'بروز' ),
	'ExportRDF' => array( 'آر_ڈی_اف_ئی_ڈن_کورتین' ),
	'PageProperty' => array( 'تاکدیمی_مالومات' ),
	'Properties' => array( 'مالومات' ),
	'Concepts' => array( 'موّزو_ئان' ),
	'SMWAdmin' => array( 'اس_ام_ڈبلیو_ئی_مدیر' ),
	'SearchByProperty' => array( 'گشتین_به_مالوماتی_اساس_ئا' ),
	'SemanticStatistics' => array( 'سیمانتیکین_سرجم' ),
	'Types' => array( 'ڈوّل_ئان' ),
	'URIResolver' => array( 'یو_آر_آی_هل_کنۆک' ),
	'UnusedProperties' => array( 'ایستیپاده_نه_بوته_ئین_مالومات' ),
	'WantedProperties' => array( 'لوٹی_ته_بوته_ئین_مالومات' ),
);

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = array(
	'Ask' => array( 'Takun' ),
	'Browse' => array( 'Ambahi' ),
	'Types' => array( 'Janis' ),
);

/** Breton (brezhoneg) */
$specialPageAliases['br'] = array(
	'Ask' => array( 'Goulenn' ),
	'Browse' => array( 'Furchal' ),
	'ExportRDF' => array( 'EzorzhiañRDF' ),
	'PageProperty' => array( 'PerzhioùPajenn' ),
	'Properties' => array( 'Perzhioù' ),
	'Types' => array( 'Seurtoù' ),
);

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = array(
	'Ask' => array( 'Upit' ),
	'Browse' => array( 'Pregledanje' ),
	'ExportRDF' => array( 'IzvozRDF' ),
	'Properties' => array( 'Svojstva' ),
);

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = array(
	'Ask' => array( '問' ),
	'Browse' => array( '瀏覽' ),
	'ExportRDF' => array( '導出RDF' ),
	'PageProperty' => array( '頁面屬性' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'Ask' => array( 'Semantische_Suche' ),
	'Browse' => array( 'Durchsuchen', 'Browsen' ),
	'ExportRDF' => array( 'RDF_exportieren', 'Exportiere_RDF' ),
	'PageProperty' => array( 'Seitenattribut' ),
	'Properties' => array( 'Attribute' ),
	'Concepts' => array( 'Konzepte' ),
	'SMWAdmin' => array( 'SemanticMediaWiki', 'SMW-Administration', 'SMW-Einrichtung' ),
	'SearchByProperty' => array( 'Suche_mittels_Attribut' ),
	'ProcessingErrorList' => array( 'Liste_der_Verarbeitungsfehler' ),
	'PropertyLabelSimilarity' => array( 'Ähnliche_Attributbezeichnungen' ),
	'SemanticStatistics' => array( 'Semantische_Statistik' ),
	'Types' => array( 'Datentypen' ),
	'URIResolver' => array( 'URI-Auflöser' ),
	'UnusedProperties' => array( 'Verwaiste_Attribute' ),
	'WantedProperties' => array( 'Gewünschte_Attribute' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'Ask' => array( 'Pers' ),
	'Browse' => array( 'Bıgeyré' ),
	'ExportRDF' => array( 'RDFTeberde' ),
	'PageProperty' => array( 'BeğsaPeran' ),
	'Properties' => array( 'Bexsiyeti' ),
	'Concepts' => array( 'Konsepti' ),
	'SMWAdmin' => array( 'SMWXızmetkar' ),
	'SearchByProperty' => array( 'ĞısusiyetkarCıgeyrayış' ),
	'SemanticStatistics' => array( 'İstatistikéFehmkerdışi' ),
	'Types' => array( 'Babeti' ),
	'URIResolver' => array( 'URIAgozne' ),
	'UnusedProperties' => array( 'ĞısusiyetéNékaréné' ),
	'WantedProperties' => array( 'ĞısusiyetéWaşténé' ),
);

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'Ask' => array( 'Semantiske pytanhje' ),
	'Browse' => array( 'Pśepytaś' ),
	'ExportRDF' => array( 'RDF eksportěrowaś' ),
	'PageProperty' => array( 'Bokowa kakosć' ),
	'Properties' => array( 'Kakosći' ),
	'SearchByProperty' => array( 'Z kakosću pytaś' ),
	'SemanticStatistics' => array( 'Semantiska statistika' ),
	'Types' => array( 'Datowe typy' ),
	'UnusedProperties' => array( 'Njewužywane kakosći' ),
	'WantedProperties' => array( 'Póžedane kakosći' ),
);

/** Divehi (ދިވެހިބަސް) */
$specialPageAliases['dv'] = array(
	'Ask' => array( 'އައްސަވާ' ),
);

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = array(
	'Ask' => array( 'Ερώτημα' ),
	'Browse' => array( 'Περιήγηση' ),
	'ExportRDF' => array( 'ΕξαγωγήRDF' ),
	'PageProperty' => array( 'ΙδιότηταΣελίδας' ),
	'Properties' => array( 'Ιδιότητες' ),
	'Concepts' => array( 'Έννοιες' ),
	'SMWAdmin' => array( 'ΔιαχείρισηSMW' ),
	'SearchByProperty' => array( 'ΑναζήτησηΜεΙδιότητα' ),
	'SemanticStatistics' => array( 'ΣημασιολογικάΣτατιστικά' ),
	'Types' => array( 'Τύποι' ),
	'URIResolver' => array( 'ΑναλυτήςURI' ),
	'UnusedProperties' => array( 'ΜηΧρησιμοποιούμενεςΙδιότητες' ),
	'WantedProperties' => array( 'ΖητούμενεςΙδιότητες' ),
);

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = array(
	'Ask' => array( 'Peti' ),
	'Browse' => array( 'Foliumi' ),
	'ExportRDF' => array( 'Elporti_RDF', 'Eksporti_RDF' ),
	'PageProperty' => array( 'Ecoj_de_paĝo' ),
	'Properties' => array( 'Ecoj' ),
	'Types' => array( 'Specoj' ),
);

/** Spanish (español) */
$specialPageAliases['es'] = array(
	'Properties' => array( 'Propiedades' ),
	'SearchByProperty' => array( 'BuscarPorPropiedad' ),
	'Types' => array( 'Tipos' ),
	'UnusedProperties' => array( 'PropiedadesNoUsadas' ),
	'WantedProperties' => array( 'PropiedadesRequeridas' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'Ask' => array( 'پرسش' ),
	'Browse' => array( 'مرور' ),
	'ExportRDF' => array( 'برونریزی_آردی‌اف' ),
	'PageProperty' => array( 'جزئیات_صفحه' ),
	'Properties' => array( 'جزئیات' ),
	'Concepts' => array( 'مفاهیم' ),
	'SMWAdmin' => array( 'مدیر_اس‌ام‌دبلیو' ),
	'SearchByProperty' => array( 'جستجو_بر_پایهٔ_جزئیات' ),
	'SemanticStatistics' => array( 'آمار_سمانیک' ),
	'Types' => array( 'نوع‌ها' ),
	'URIResolver' => array( 'حل‌کننده_یو‌آر‌آی' ),
	'UnusedProperties' => array( 'جزئیات_استفاده_نشده' ),
	'WantedProperties' => array( 'جزئیات_درخواستی' ),
);

/** Finnish (suomi) */
$specialPageAliases['fi'] = array(
	'Ask' => array( 'Kysy' ),
	'Browse' => array( 'Selaa' ),
	'ExportRDF' => array( 'RDF-vienti' ),
	'Properties' => array( 'Ominaisuudet' ),
	'SMWAdmin' => array( 'Semanttisen_Mediawikin_ylläpito' ),
	'SemanticStatistics' => array( 'Semanttiset_tilastot' ),
	'Types' => array( 'Tyypit' ),
	'UnusedProperties' => array( 'Käyttämättömät_ominaisuudet' ),
	'WantedProperties' => array( 'Halutut_ominaisuudet' ),
);

/** French (français) */
$specialPageAliases['fr'] = array(
	'Ask' => array( 'Requêter' ),
	'Browse' => array( 'Parcourir' ),
	'ExportRDF' => array( 'Export_RDF' ),
	'PageProperty' => array( 'Propriétés_de_la_page' ),
	'Properties' => array( 'Propriétés' ),
	'Concepts' => array( 'Concepts' ),
	'SearchByProperty' => array( 'Recherche_par_propriété' ),
	'SemanticStatistics' => array( 'Statistiques_sémantiques' ),
	'Types' => array( 'Types' ),
	'UnusedProperties' => array( 'Propriétés_inutilisées' ),
	'WantedProperties' => array( 'Propriétés_demandées' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'Ask' => array( 'Preguntar' ),
	'Browse' => array( 'Navegar' ),
	'ExportRDF' => array( 'Exportar_RDF' ),
	'PageProperty' => array( 'Propiedades_da_páxina' ),
	'Properties' => array( 'Propiedades' ),
	'Concepts' => array( 'Conceptos' ),
	'SearchByProperty' => array( 'Procurar_por_propiedades' ),
	'SemanticStatistics' => array( 'Estatísticas_semánticas' ),
	'Types' => array( 'Tipos' ),
	'UnusedProperties' => array( 'Propiedades_sen_uso' ),
	'WantedProperties' => array( 'Propiedades_requiridas' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'Ask' => array( 'Semantischi_Suech' ),
	'Browse' => array( 'Duresueche' ),
	'ExportRDF' => array( 'Exportier_ADF' ),
	'PageProperty' => array( 'Syteattribut' ),
	'Properties' => array( 'Attribut' ),
	'SMWAdmin' => array( 'SMW-Yyrichtig' ),
	'SearchByProperty' => array( 'Suech_no_Attribut' ),
	'SemanticStatistics' => array( 'Semantischi_Statischtik' ),
	'Types' => array( 'Datetype' ),
	'URIResolver' => array( 'URI-Ufflöser' ),
	'UnusedProperties' => array( 'Verwaisti_Attribut' ),
	'WantedProperties' => array( 'Gwinschti_Attribut' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'Ask' => array( 'שאלה' ),
	'Browse' => array( 'עיון' ),
	'ExportRDF' => array( 'ייצור_RDF' ),
	'PageProperty' => array( 'מאפיין_דף' ),
	'Properties' => array( 'מאפיינים' ),
	'Concepts' => array( 'רעיונות' ),
	'SMWAdmin' => array( 'ניהול_SMW' ),
	'SearchByProperty' => array( 'חיפוש_לפי_שאילתה' ),
	'SemanticStatistics' => array( 'סטטיסטיקות_סמנטיות' ),
	'Types' => array( 'סוגים' ),
	'URIResolver' => array( 'פותר_URI' ),
	'UnusedProperties' => array( 'מאפיינים_שאינם_בשימוש' ),
	'WantedProperties' => array( 'מאפיינים_מבוקשים' ),
);

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = array(
	'Ask' => array( 'पूछो' ),
);

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'Ask' => array( 'Semantiske_pytanje' ),
	'Browse' => array( 'Přepytać' ),
	'ExportRDF' => array( 'RDF_eksportować' ),
	'PageProperty' => array( 'Kajkosć_strony' ),
	'Properties' => array( 'Kajkosće' ),
	'Concepts' => array( 'Koncepty' ),
	'SMWAdmin' => array( 'SMW-administracija' ),
	'SearchByProperty' => array( 'Pytanje_po_kajkosći' ),
	'SemanticStatistics' => array( 'Semantiska_statistika' ),
	'Types' => array( 'Datowe_typy' ),
	'UnusedProperties' => array( 'Njewužiwane_kajkosće' ),
	'WantedProperties' => array( 'Falowace_kajkosće' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'Ask' => array( 'Mande' ),
	'Browse' => array( 'Navige' ),
	'ExportRDF' => array( 'EkspòteRDF' ),
	'PageProperty' => array( 'ProprietePaj' ),
	'Properties' => array( 'Propriete' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'ChachePaPropriete' ),
	'SemanticStatistics' => array( 'EstatistikSemantik' ),
	'Types' => array( 'Tip' ),
	'UnusedProperties' => array( 'ProprietePaSèvi' ),
	'WantedProperties' => array( 'ProprieteKiMande' ),
);

/** Hungarian (magyar) */
$specialPageAliases['hu'] = array(
	'Ask' => array( 'Kérdez' ),
	'Browse' => array( 'Böngészés' ),
	'Properties' => array( 'Tulajdonságok' ),
	'SemanticStatistics' => array( 'Szemantikus_statisztika' ),
	'Types' => array( 'Típusok' ),
	'URIResolver' => array( 'URI-feloldó' ),
	'UnusedProperties' => array( 'Nem_használt_tulajdonságok' ),
	'WantedProperties' => array( 'Keresett_tulajdonságok' ),
);

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = array(
	'Ask' => array( 'Consultar' ),
	'Browse' => array( 'Percurrer' ),
	'ExportRDF' => array( 'Exportar_RDF' ),
	'PageProperty' => array( 'Proprietate_de_pagina' ),
	'Properties' => array( 'Proprietates' ),
	'SMWAdmin' => array( 'Admin_SMW' ),
	'SearchByProperty' => array( 'Cercar_per_proprietate' ),
	'SemanticStatistics' => array( 'Statisticas_semantic' ),
	'Types' => array( 'Typos' ),
	'URIResolver' => array( 'Resolvitor_de_URIs' ),
	'UnusedProperties' => array( 'Proprietates_non_usate' ),
	'WantedProperties' => array( 'Proprietates_dsesirate' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'Ask' => array( 'Tanya' ),
	'Browse' => array( 'Jelajahi' ),
	'ExportRDF' => array( 'EksporRDF' ),
	'PageProperty' => array( 'PropertiHalaman' ),
	'Properties' => array( 'Properti' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'PencarianProperti' ),
	'SemanticStatistics' => array( 'StatistikSemantik' ),
	'Types' => array( 'Tipe' ),
	'URIResolver' => array( 'PenguraiURI' ),
	'UnusedProperties' => array( 'PropertiTakDigunakan' ),
	'WantedProperties' => array( 'PropertiDiinginkan' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'Ask' => array( 'Chiedi' ),
	'Browse' => array( 'Esplora' ),
	'ExportRDF' => array( 'EsportaRDF' ),
	'PageProperty' => array( 'ProprietàPagina' ),
	'Properties' => array( 'Proprietà' ),
	'Concepts' => array( 'Concetti' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'CercaPerProprietà' ),
	'SemanticStatistics' => array( 'StatisticheSemantiche' ),
	'Types' => array( 'Tipi' ),
	'URIResolver' => array( 'RisolutoreURI' ),
	'UnusedProperties' => array( 'ProprietàNonUtilizzate' ),
	'WantedProperties' => array( 'ProprietàRichieste' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'Ask' => array( '問い合わせ', '意味的検索' ),
	'Browse' => array( '閲覧' ),
	'ExportRDF' => array( 'RDF書き出し', 'RDFエクスポート', 'ＲＤＦエクスポート' ),
	'PageProperty' => array( 'ページプロパティ' ),
	'Properties' => array( 'プロパティ一覧' ),
	'Concepts' => array( '概念' ),
	'SMWAdmin' => array( 'SMW管理', 'ＳＭＷ管理' ),
	'SearchByProperty' => array( 'プロパティによる検索' ),
	'SemanticStatistics' => array( '意味的統計' ),
	'Types' => array( '型一覧' ),
	'URIResolver' => array( 'URIリゾルバー', 'ＵＲＩリゾルバー' ),
	'UnusedProperties' => array( '使われていないプロパティ' ),
	'WantedProperties' => array( '望まれているプロパティ' ),
);

/** Georgian (ქართული) */
$specialPageAliases['ka'] = array(
	'Types' => array( 'ტიპები' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'Browse' => array( 'រាវរក' ),
	'Properties' => array( 'លក្ខណៈ' ),
	'Types' => array( 'ប្រភេទ' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'Ask' => array( '묻기' ),
	'Browse' => array( '찾아보기' ),
	'ExportRDF' => array( 'RDF내보내기' ),
	'PageProperty' => array( '문서속성' ),
	'Properties' => array( '속성목록' ),
	'Concepts' => array( '개념목록' ),
	'SMWAdmin' => array( 'SMW관리자' ),
	'SearchByProperty' => array( '속성별검색', '속성별찾기' ),
	'SemanticStatistics' => array( '시맨틱통계' ),
	'Types' => array( '종류목록' ),
	'URIResolver' => array( 'URI해결' ),
	'UnusedProperties' => array( '안쓰는속성', '쓰이지않는속성' ),
	'WantedProperties' => array( '필요한속성' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'Ask' => array( 'Froore' ),
	'Browse' => array( 'Bläddere' ),
	'ExportRDF' => array( 'RDF', 'RDF Äxpotteere' ),
	'PageProperty' => array( 'Eijeschaffte vun Sigge' ),
	'Properties' => array( 'Eijeschaffte' ),
	'SMWAdmin' => array( 'Semantesch MediaWiki Ennreschte' ),
	'SearchByProperty' => array( 'Noh Eijeschaffte söke' ),
	'SemanticStatistics' => array( 'Semantesch Shtatistike' ),
	'Types' => array( 'Zoote vun Daate' ),
	'UnusedProperties' => array( 'Eijeschaffte di nit jebruch wääde' ),
	'WantedProperties' => array( 'Eijeschaffte di noch jebruch wääde' ),
);

/** Cornish (kernowek) */
$specialPageAliases['kw'] = array(
	'Ask' => array( 'Govyn' ),
	'Browse' => array( 'Peuri' ),
	'ExportRDF' => array( 'EsperthiRDF' ),
	'PageProperty' => array( 'GnasFolen' ),
	'Properties' => array( 'Gnasow' ),
	'SearchByProperty' => array( 'HwilasHerwydhGnas' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'Ask' => array( 'Froen' ),
	'Browse' => array( 'Browsen' ),
	'ExportRDF' => array( 'RDF_exportéieren' ),
	'PageProperty' => array( 'Säiten-Eegeschaften' ),
	'Properties' => array( 'Eegeschaften' ),
	'Concepts' => array( 'Konzepter' ),
	'SMWAdmin' => array( 'SMW-Administratioun' ),
	'SearchByProperty' => array( 'No_Eegeschaft_sichen' ),
	'SemanticStatistics' => array( 'Semantesch_Statistiken' ),
	'Types' => array( 'Datentypen' ),
	'UnusedProperties' => array( 'Netbenotzt_Eegeschaften' ),
	'WantedProperties' => array( 'Gewënscht_Eegeschaften' ),
);

/** Lombard (lumbaart) */
$specialPageAliases['lmo'] = array(
	'Ask' => array( 'Ciama' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'Ask' => array( 'Прашај' ),
	'Browse' => array( 'Прелистај' ),
	'ExportRDF' => array( 'ИзвезиRDF' ),
	'PageProperty' => array( 'СвојстваНаСтраница' ),
	'Properties' => array( 'Својства' ),
	'Concepts' => array( 'Концепти' ),
	'SMWAdmin' => array( 'СМВАдминистратор' ),
	'SearchByProperty' => array( 'ПребарајПоСвојство' ),
	'SemanticStatistics' => array( 'СемантичкиСтатистики' ),
	'Types' => array( 'Типови' ),
	'URIResolver' => array( 'URIРешавач' ),
	'UnusedProperties' => array( 'НекористениСвојства' ),
	'WantedProperties' => array( 'ПотребниСвојства' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'Ask' => array( 'ചോദിക്കുക' ),
	'Browse' => array( 'ബ്രൗസ്' ),
	'Types' => array( 'തരങ്ങൾ' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'Ask' => array( 'विचारा' ),
	'Browse' => array( 'न्याहाळा' ),
	'ExportRDF' => array( 'आरडीएफनिर्यात' ),
	'PageProperty' => array( 'पानवैशिष्ट्ये' ),
	'Properties' => array( 'वैशिष्ट्ये' ),
	'Concepts' => array( 'संकल्पना' ),
	'SMWAdmin' => array( 'एसएमडब्ल्यूप्रचालक' ),
	'SearchByProperty' => array( 'वैशिष्ट्येनुसारशोध' ),
	'SemanticStatistics' => array( 'सिमॅंटीकसांख्यिकी' ),
	'Types' => array( 'प्रकार' ),
	'URIResolver' => array( 'यूआरायरिझॉल्व्हर' ),
	'UnusedProperties' => array( 'नवापरलेलीवैशिष्ट्ये' ),
	'WantedProperties' => array( 'हवीअसलेलीवैशिष्ट्ये' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'Ask' => array( 'Staqsi' ),
	'Browse' => array( 'Esplora' ),
);

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = array(
	'Ask' => array( 'Spør' ),
	'Browse' => array( 'Se_gjennom' ),
	'ExportRDF' => array( 'Eksporter_RDF' ),
	'PageProperty' => array( 'Sideegenskaper' ),
	'Properties' => array( 'Egenskaper' ),
	'Concepts' => array( 'Konsepter' ),
	'SMWAdmin' => array( 'SMW-administrasjon' ),
	'SearchByProperty' => array( 'Søk_etter_egenskap' ),
	'SemanticStatistics' => array( 'Semantisk_statistikk' ),
	'Types' => array( 'Typer' ),
	'URIResolver' => array( 'URI-løser' ),
	'UnusedProperties' => array( 'Ubrukte_egenskaper' ),
	'WantedProperties' => array( 'Ønskede_egenskaper' ),
);

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = array(
	'Ask' => array( 'Vragen' ),
	'Browse' => array( 'Bekieken' ),
	'ExportRDF' => array( 'RDF_uutvoeren' ),
	'PageProperty' => array( 'Ziedeigenschap' ),
	'Properties' => array( 'Eigenschappen' ),
	'Concepts' => array( 'Konsepten' ),
	'SMWAdmin' => array( 'SMW-beheer' ),
	'SearchByProperty' => array( 'Op_eigenschap_zeuken' ),
	'SemanticStatistics' => array( 'Semantiese_staotistieken' ),
	'Types' => array( 'Soorten' ),
	'URIResolver' => array( 'URI-oplosser' ),
	'UnusedProperties' => array( 'Ongebruukten_eigenschappen' ),
	'WantedProperties' => array( 'Gewunste_eigenschappen' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'Ask' => array( 'Vragen' ),
	'Browse' => array( 'Bekijken' ),
	'ExportRDF' => array( 'RDFExporteren' ),
	'PageProperty' => array( 'Paginaeigenschap' ),
	'Properties' => array( 'Eigenschappen' ),
	'Concepts' => array( 'Concepten' ),
	'SMWAdmin' => array( 'SMWBeheer' ),
	'SearchByProperty' => array( 'OpEigenschapZoeken' ),
	'SemanticStatistics' => array( 'SemantischeStatistieken' ),
	'Types' => array( 'Typen' ),
	'UnusedProperties' => array( 'OngebruikteEigenschappen' ),
	'WantedProperties' => array( 'GewensteEigenschappen' ),
);

/** Occitan (occitan) */
$specialPageAliases['oc'] = array(
	'Browse' => array( 'Percórrer' ),
	'Properties' => array( 'Proprietats' ),
	'Types' => array( 'Tipes' ),
	'UnusedProperties' => array( 'Proprietats inutilizadas', 'ProprietatsInutilizadas' ),
	'WantedProperties' => array( 'Proprietats demandadas', 'ProprietatsDemandadas' ),
);

/** Oriya (ଓଡ଼ିଆ) */
$specialPageAliases['or'] = array(
	'Ask' => array( 'ପଚାରନ୍ତୁ' ),
	'Browse' => array( 'ଖୋଜିବା' ),
	'PageProperty' => array( 'ପୃଷ୍ଠାର_ଗୁଣ' ),
	'Properties' => array( 'ଗୁଣ' ),
	'UnusedProperties' => array( 'ବ୍ୟବହାର_ହୋଇନଥିବା_ଗୁଣ' ),
	'WantedProperties' => array( 'ଦରକାରୀ_ଗୁଣ' ),
);

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = array(
	'Ask' => array( 'ਪੁੱਛੋ' ),
	'Browse' => array( 'ਫੇਰੀ_ਪਾਓ' ),
	'Types' => array( 'ਕਿਸਮਾਂ' ),
);

/** Polish (polski) */
$specialPageAliases['pl'] = array(
	'Ask' => array( 'Pytanie' ),
	'Browse' => array( 'Przegląd' ),
	'ExportRDF' => array( 'EksportRDF' ),
	'PageProperty' => array( 'WłasnośćStrony' ),
	'Properties' => array( 'Własności' ),
	'Concepts' => array( 'Koncepty' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'SzukanieWgWłasności' ),
	'SemanticStatistics' => array( 'StatystykiSemantyczne' ),
	'Types' => array( 'Typy' ),
	'URIResolver' => array( 'ResolverURI' ),
	'UnusedProperties' => array( 'NieużywaneWłasności' ),
	'WantedProperties' => array( 'PotrzebneWłasności' ),
);

/** Pashto (پښتو) */
$specialPageAliases['ps'] = array(
	'Ask' => array( 'پوښتل' ),
	'Browse' => array( 'سپړل' ),
	'PageProperty' => array( 'د مخ ځانتياوې' ),
	'Properties' => array( 'ځانتياوې' ),
	'Types' => array( 'ډولونه' ),
	'UnusedProperties' => array( 'ناکارېدلې ځانتياوې' ),
);

/** Portuguese (português) */
$specialPageAliases['pt'] = array(
	'Ask' => array( 'Consultar' ),
	'Browse' => array( 'Navegar' ),
	'ExportRDF' => array( 'ExportarRDF' ),
	'PageProperty' => array( 'Propriedade_de_página' ),
	'Properties' => array( 'Propriedades' ),
	'Concepts' => array( 'Conceitos' ),
	'SearchByProperty' => array( 'Pesquisa_por_propriedade' ),
	'SemanticStatistics' => array( 'Estatísticas_de_semântica' ),
	'Types' => array( 'Tipos' ),
	'UnusedProperties' => array( 'Propriedades_não_utilizadas' ),
	'WantedProperties' => array( 'Propriedades_desejadas' ),
);

/** Brazilian Portuguese (português do Brasil) */
$specialPageAliases['pt-br'] = array(
	'Ask' => array( 'Consultar' ),
	'Browse' => array( 'Navegar' ),
	'ExportRDF' => array( 'ExportarRDF' ),
	'PageProperty' => array( 'Propriedade_de_página' ),
	'Properties' => array( 'Propriedades' ),
	'SMWAdmin' => array( 'SMWAdmin' ),
	'SearchByProperty' => array( 'Pesquisa_por_propriedade' ),
	'SemanticStatistics' => array( 'Estatísticas_de_semântica' ),
	'Types' => array( 'Tipos' ),
	'URIResolver' => array( 'URIResolver' ),
	'UnusedProperties' => array( 'Propriedades_não_utilizadas' ),
	'WantedProperties' => array( 'Propriedades_desejadas' ),
);

/** Romanian (română) */
$specialPageAliases['ro'] = array(
	'Browse' => array( 'Răsfoieşte' ),
);

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = array(
	'Ask' => array( 'Chiedi' ),
	'Browse' => array( 'Esplora' ),
	'ExportRDF' => array( 'EsportaRDF' ),
	'PageProperty' => array( 'ProprietàPagina' ),
	'Properties' => array( 'Proprietà' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'CercaPerProprietà' ),
	'SemanticStatistics' => array( 'StatisticheSemantiche' ),
	'Types' => array( 'Tipi' ),
	'URIResolver' => array( 'RisolutoreURI' ),
	'UnusedProperties' => array( 'ProprietàNonUtilizzate' ),
	'WantedProperties' => array( 'ProprietàRichieste' ),
);

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = array(
	'Ask' => array( 'SpýtaťSa' ),
	'Browse' => array( 'Prehliadať' ),
	'PageProperty' => array( 'VlastnostiStránky' ),
	'Properties' => array( 'Vlastnosti' ),
	'SMWAdmin' => array( 'SprávcaSMW' ),
	'SearchByProperty' => array( 'HľadaniePodľaVlastností' ),
	'SemanticStatistics' => array( 'SémantickéŠtatistiky' ),
	'Types' => array( 'Typy' ),
	'URIResolver' => array( 'PrekladURI' ),
	'UnusedProperties' => array( 'NepoužívanéVlastnosti' ),
	'WantedProperties' => array( 'ŽiadanéVlastnosti' ),
);

/** Albanian (shqip) */
$specialPageAliases['sq'] = array(
	'Ask' => array( 'Pyet' ),
	'Browse' => array( 'Sille' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = array(
	'Ask' => array( 'Питај' ),
	'Browse' => array( 'Потражи' ),
	'Properties' => array( 'Својства' ),
	'Types' => array( 'Врсте' ),
	'UnusedProperties' => array( 'НекоришћенаСвојства', 'Некоришћена_својства' ),
	'WantedProperties' => array( 'ТраженаСвојства', 'Тражена_својства' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'Ask' => array( 'Fråga' ),
	'Browse' => array( 'Bläddra' ),
	'ExportRDF' => array( 'Exportera_RDF' ),
	'Properties' => array( 'Egenskaper' ),
	'Types' => array( 'Typer' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'Ask' => array( 'Uliza' ),
	'Browse' => array( 'Fungua' ),
	'Types' => array( 'Aina' ),
);

/** Telugu (తెలుగు) */
$specialPageAliases['te'] = array(
	'Ask' => array( 'అడుగు' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'Ask' => array( 'Magtanong' ),
	'Browse' => array( 'Tumingin-tingin' ),
	'ExportRDF' => array( 'Iluwas_ang_RDF' ),
	'PageProperty' => array( 'Pag-aari_ng_pahina' ),
	'Properties' => array( 'Mga_pag-aari' ),
	'SMWAdmin' => array( 'Tagapangasiwa_ng_SMW' ),
	'SearchByProperty' => array( 'Maghanap_ayon_sa_pag-aari' ),
	'SemanticStatistics' => array( 'Mga_estadistika_ng_semantiko' ),
	'Types' => array( 'Mga_uri' ),
	'URIResolver' => array( 'Tagapaglutas_ng_URI' ),
	'UnusedProperties' => array( 'Mga_pag-aaring_hindi_ginagamit' ),
	'WantedProperties' => array( 'Mga_pag-aaring_ninanais' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'Ask' => array( 'Sor' ),
	'Browse' => array( 'Gezin' ),
	'ExportRDF' => array( 'RDFAktar' ),
	'PageProperty' => array( 'SayfaÖzelliği' ),
	'Properties' => array( 'Özellikler' ),
	'SMWAdmin' => array( 'SMWHizmetlisi', 'SMWYöneticisi' ),
	'SearchByProperty' => array( 'ÖzelliğeGöreAra' ),
	'SemanticStatistics' => array( 'Anlamİstatistikleri' ),
	'Types' => array( 'Türler', 'Tipler' ),
	'URIResolver' => array( 'URIÇözücü' ),
	'UnusedProperties' => array( 'KullanılmayanÖzellikler' ),
	'WantedProperties' => array( 'İstenenÖzellikler' ),
);

/** Ukrainian (українська) */
$specialPageAliases['uk'] = array(
	'Properties' => array( 'Властивості' ),
	'Types' => array( 'Типи' ),
);

/** Urdu (اردو) */
$specialPageAliases['ur'] = array(
	'Ask' => array( 'پوچھیں' ),
	'Types' => array( 'اقسام' ),
);

/** Venetian (vèneto) */
$specialPageAliases['vec'] = array(
	'Browse' => array( 'Sfója' ),
	'Properties' => array( 'Proprietà' ),
	'Types' => array( 'Tipi' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'Ask' => array( 'Hỏi' ),
	'Browse' => array( 'Duyệt' ),
	'ExportRDF' => array( 'Xuất_RDF' ),
	'PageProperty' => array( 'Thuộc_tính_trang' ),
	'Properties' => array( 'Thuộc_tính' ),
	'Concepts' => array( 'Khái_niệm' ),
	'SMWAdmin' => array( 'Quản_lý_SMW', 'Quản_lí_SMW' ),
	'SearchByProperty' => array( 'Tìm_theo_thuộc_tính' ),
	'SemanticStatistics' => array( 'Thống_kê_ngữ_nghĩa' ),
	'Types' => array( 'Kiểu' ),
	'URIResolver' => array( 'Bộ_giải_URI' ),
	'UnusedProperties' => array( 'Thuộc_tính_không_dùng' ),
	'WantedProperties' => array( 'Thuộc_tính_cần_thiết' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'Ask' => array( '询问' ),
	'Browse' => array( '浏览' ),
	'ExportRDF' => array( '导出RDF' ),
	'PageProperty' => array( '页面属性' ),
	'Properties' => array( '属性' ),
	'Concepts' => array( '概念' ),
	'SMWAdmin' => array( 'SMW管理' ),
	'SearchByProperty' => array( '按属性搜索' ),
	'SemanticStatistics' => array( '语义统计' ),
	'Types' => array( '类型' ),
	'URIResolver' => array( 'URI分解器' ),
	'UnusedProperties' => array( '未使用属性' ),
	'WantedProperties' => array( '尚缺属性' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'Ask' => array( '詢問' ),
	'Browse' => array( '瀏覽' ),
	'ExportRDF' => array( '匯出_RDF' ),
	'PageProperty' => array( '頁面屬性' ),
	'Properties' => array( '屬性' ),
	'Concepts' => array( '概念' ),
	'SMWAdmin' => array( 'SMW_管理員' ),
	'SearchByProperty' => array( '依屬性搜尋' ),
	'SemanticStatistics' => array( '語意統計' ),
	'Types' => array( '型態' ),
	'URIResolver' => array( 'URI_分解器' ),
	'UnusedProperties' => array( '未使用屬性' ),
	'WantedProperties' => array( '需要的屬性' ),
);
