These are the release notes of SMW up to version 1.5.6.
For version 1.6 and later, see the dedicated files in this directory.

== SMW 1.5.6 ==

* Automatic refresh of pages after parsing their semantic data.
* Fixed several bugs including non-functional concept caching,
  correct internationalization support for categories and concepts
  in queries and types display on Special:Types for MW >= 1.18.

== SMW 1.5.5 ==

* Support for Turtle syntax (e.g. use "syntax=turtle" as a parameter to 
  when calling Special:ExportRDF.
* New query format "rdf" to export query results to RDF; the "syntax" 
  parameter can be set to "rdfxml" or "turtle" to specify a syntax.
* Fixed several bugs, including whitespace problems in queries using the
  list format, an issue with large offset values and DatatypeProperties
  being declared as ObjectProperties.
* More modular export code (split one file into 3), simplifies 
  manipulation and maintenance.

== SMW 1.5.4 ==

* Fixed several bugs, including problems with #declare, the extra options
  on Special:Ask and the style of the factbox and tables when using MW 1.17.
* Various style and documentation improvements and translation updates.

== SMW 1.5.3 ==

* Compatibility with MediaWiki 1.17
* Added << and >> comparators for strict comparisons. Also added ≤ and ≥ for
  non-strict comparisons. And introduced $smwStrictComparators setting that
  allows changing the behavior of < and > to doing strict comparisons.
* Various style and documentation improvements and translation updates.

== SMW 1.5.2 ==

* 'Printouts' textarea in Special:Ask now has autocompletion on property
  names.
* SMW now has it's own copy of the jQuery and jQuery UI libraries.
* Added a number of hooks to allow further customization by extensions.
* 'Semantic' extension type that can be used by extensions to SMW to be
  grouped together on Special:Version and other pages listing extensions.
* Various bugfixes, style and documentation improvements and translation updates.

== SMW 1.5.1 ==

* Added query comparator "!~" that works like the negation of "~", i.e. that
  retrieves exactly those values to which the provided pattern (with * and ?)
  does not match.
* Updated OWL/RDF export to include more data (modification dates, and page
  namespaces). Changed export ontology to no longer use OWL AnnoationProperties
  since OWL 2 DL supports property values also for classes/properties.
* Improvements in code style and structure, following general MediaWiki
  conventions. Most notably, the file to include for loading SMW now is
  SemanticMediaWiki.php in the base directory (including the old Settings.php
  will still work).
* Preparation of future "SMWLight" release for wikis that want to enable users
  to add property values to pages, but which do not want to include complex
  query features.
* Added a nmber of hooks to improve compatibility with extensions.
* Various bugfixes, and translation updates.

== SMW 1.5.0 ==

* The former multi-valued/n-ary properties are now supported by a dedicated
  datatype Record. Wikis that use the old style of these properties need to
  update affected property pages as described at
  http://semantic-mediawiki.org/wiki/SMW_1.5.0
* The Type:Geographic_coordinates has been moved from SMW to the SemanticMaps
  extension. Wikis that use this datatype need to install this extension to get
  it back.
* The "like" comparator ~ in inline queries is now enabled by default. To use
  the former setting, use $smwgQComparators = '<|>|!'; in your LocalSettings.php.
* A new datatype, "Telephone number", has been introduced for validating phone
  numbers based on RFC 3966. Only global phone numbers are accepted, and no
  vanity numbers (those containing letters) are allowed. Use Type:String if
  you want to store more general strings as telephone numbers.
* Support for additional parameters for ?printouts in inline queries, specified
  by |+parameter=value after the printout. Currently supported are
  *  limit: set the maximum number of values for this printout
  *	 order: order values ascending or descending
  *  align: right/center/left alignment for printouts in tables
  *  index: directly address one value of a multi-valued (n-ary) property
* Support for inverse properties: use "-" in front of property names anywhere to
  refer to the inverse direction of a property. Works in browsing interfaces,
  queries, and query output directives. In queries only for properties of Type:Page.
* New configuration options $smwgUseCategoryHierarchy and $smwgCategoriesAsInstances
  to configure how MediaWiki categories should be interpreted by SMW.
* Compatibility with new MediaWiki skin "Vector" and with MediaWiki 1.16.
* Removed support for backwards compatibility to SMW <1.0 ($smwgSMWBetaCompatible).
* The page Special:Ask was overhauled to include inputs for entering values
  for the selected format's parameters, and to use Ajax where possible
* To that end, each format's query printer now includes a getParameters()
  function that supplies the name and attributes of each the format's parameters
* "before" and "after" hooks for updateData() and deleteSubject() were added
* A hook was added for deleteSemanticData() as well

== SMW 1.4.3 ==

See http://semantic-mediawiki.org/wiki/SMW_1.4.3

* A new query format, 'category', that displays values in the style of a
  MediaWiki category page
* A new 'columns' parameter for the 'ol' and 'ul' formats
* The 'csv' format now prints a header row by default
* The "::~" comparator in queries can now also be used for properties of type
  Geographical coordinate, to find points within a certain distance
* Using "-" as an output format for query printouts, or leaving the formatting
  string empty now leads to printout values being returned as plain, unformatted
  values. Recall that the general format for printouts in #ask is as follows:
   ?propertyname # format = label
* New special property "Has improper value for" can be used to track input errors
  (links pages where error happened to properties for which improper data was given).
* New configuration parameter $smwgMaxNonExpNumber to set the maximal number that
  SMW will normally display without using scientific exp notation. Defaults to
  1000000000000000.
* New configuration parameter $smwgMaxPropertyValues to control number of values
  that are shown for each page in the listing on Property pages. Defaults to 3.
* Now a set of stores can be added, e.g. virtual stores, and then the new #ask
  parameter "source" is used to rout to a specific store.
* Labels for inverse properties can be used to improve the output of the Browse
  special page.
* The #ask parameter "headers" can now be given the value "plain" to get query
  results that show the printout label (e.g. property name) but without a link.
* Special:PageProperty now shows all values of a property when omitting the subject.
* Numerous bugfixes

== SMW 1.4.2 ==

See http://semantic-mediawiki.org/wiki/SMW_1.4.2

* Improved performance. Significantly improved memory usage on common
  operations.
* Initial support for running SMW on PostgreSQL (testing needed).
* The query formats 'vcard' and 'icalendar' have been moved to the Semantic
  Result Formats extension to make the SMW core more light-weight
* SMW_refreshData.php now supports parameter --page to specify one or more
  pages to be updated (instead of using ID ranges)
* Various bugfixes
* Extended translations

== SMW 1.4.1 ==

See http://semantic-mediawiki.org/wiki/SMW_1.4.1

* Improved parsing support for Type:Date, fixing some open issues
* Various bugfixes
* Extended translations

== SMW 1.4.0 ==

See http://semantic-mediawiki.org/wiki/SMW_1.4.0

* Easier installation, upgrade, repair:
  Special:SMWAdmin now has a control for refreshing the wiki data online.
* Better Type:Date
  ** much larger range of dates, covering all of human history
  ** internationalisation, support for localised date formats in input
  ** support for single year numbers in dates
  ** incomplete dates handled properly
* Query for page modification date using Property:Modification_date
* Full integration of "special properties" such as Property:Has_type
  ** can be queried in #ask, and printed in printouts
  ** usable in all browsing interfaces
  ** display uses of properties on property page
* Improved parsing process
  ** avoid data loss in unusual circumstances
  ** much better compatibility with other parser extensions
* Shorter and cleaner code
* Extended translations
* Many bugfixes

== Semantic MediaWiki 1.3 ==

See http://semantic-mediawiki.org/wiki/SMW_1.3

* New design of Special:Browse: more concise and less cluttered
* Fuzzy search on Special:SearchByProperty: if an exact value is not found
  or yields only few results, pages with close-by values are also shown.
* Better result browsing on concept pages. Such pages now look like category
  pages and show results in columns.
* New mechanism for pre-computing concepts for very fast result display even
  fomr complicated queries. Relevant for wikis with large amounts of data.
  Details are documented at
  http://semantic-mediawiki.org/wiki/Help:Concept_caching
* Extended translations, support for aliases for special pages (translated
  names used in URLs).
* Various bugfixes and internal improvements for performance and robustness.

== Semantic MediaWiki 1.2.2 ==

Minor release with bugfixes:
* in rare cases undelete would create errors on pages
* inverse links for binary properties were displayed wrongly
* some additional checks to make parsing more reliable

== Semantic MediaWiki 1.2.1 ==

See http://semantic-mediawiki.org/wiki/SMW_1.2.1

* New sub-property display for property pages
* Improved number parsing, admitting arbitrary spaces in numbers
  (required for French)
* Extended translations
* Update job generation actually works now
* Query format "csv" to export data as file of comma-separated values
* Prevent crashes for very long property values (due to PHP PCRE)
* Various other bugfixes


== Semantic MediaWiki 1.2 ==

See http://semantic-mediawiki.org/wiki/SMW_1.2

* New SMW storage backend (SMWSQLStore2)
  ** faster for queries and page display/rendering
  ** full equality support built-in, no performance impact
  ** support for disjunctions in queries (keyword "OR")
* vCard export for query results
* Improved semantic query syntax and processing
  ** shortcut query syntax #show for displaying properties of
     single pages, e.g. {{#show: Berlin | ?population}}
  ** property chains like [[property1.property2::value]]
  ** more detailed control of which query features to support
     (see setting $smwgQFeatures in SMW_Settings.php)
* Support for custom sortkey to control alphabetic sorting of
  all pages, using MediaWiki's {{DEFAULTSORTKEY: custom key}}
* Support for semantic interwiki links (e.g. [[property::meta:Test]])
* Stored queries on Concept: pages (concepts as "dynamic categories"),
  see http://semantic-mediawiki.org/wiki/Help:Concepts
* Automated updates: changes in templates and property definitions
  are automatically applied to affected pages (after some time)
* Extended maintenance scripts
  ** delete an existing (now unused) SMW store with SMW_setup --delete
  ** select SMW storage engine to use for scripts with option -b <Store>
  ** SMW_dumpRDF now supports restriction to concepts or concepts+categories
* SMW <1.0 features disabled by default (remove obsolete features),
  can be re-enabled with $smwgSMWBetaCompatible.
* Compatible with Semantic Forms 1.2.3 and MediaWiki 1.13 (current devel
  version)


== Semantic MediaWiki 1.1.2 ==

* Security update to avoid vulnerabilities on sites that use PHP
  superglobals

== Semantic MediaWiki 1.1.1 ==

* Improved iCalendar support: more efficient processing, better heuristic
  for giving dates, formatting bugfixes
* Bugfix for Special:SearchByProperty (form-based search failed)
* Minor bugfixes for RSS generation
* Bugfix for Special_Ask in MediaWiki 1.11 with template formatting
* Maintenance scripts now accept the MW_INSTALL_PATH environment variable

== Semantic MediaWiki 1.1 ==

* Support for formatted results on Special:Ask. "Further results" links
  from inline queries now preserve format.
* New iCalendar export for inline queries (format=icalendar)
* Query results can now be sorted by more than one property (just separate
  property names with "," in sort parameter)
* Initial support (beta) for synching external RDF stores with SMW.
  This also provides support for wiki-based SPARQL query services, see
  http://semantic-mediawiki.org/wiki/Help:SPARQL_endpoint
* More robust link generation code; even long query texts and links
  that contain very special characters are built properly.
* Extended translations. Completely new Arab translation.
* New SMW registry http://semantic-mediawiki.org/wiki/Special:SMWRegistry
  to replace hand-crafted list of "sites using SMW".
* Various bugfixes. For example:
 ** Enumerated properties (allows value) for Type:Page works now.
 ** Page moves are handled more reliably

== Semantic MediaWiki 1.0.1 ==

* Extended translations, new Italian translation
* minor bugfixes, fixed RSS links for long description texts

== Changes in SMW1.0 as compared to SMW0.7 ==

* Simplified semantic annotations: just one kind of annotation ("Property").
* Significant speedup (both server and network load substantially reduced,
  faster RDF export, more efficient query result formatting).
* Prettier and easier to understand interfaces:
  ** New tooltips for warnings and additional information.
  ** Simplified factbox layout, with all properties in alphabetic order.
  ** Inline warnings to simplify trouble shooting with annotations.
  ** Improved, more helpful and informative warning and error messages.
  ** Highlighting for built-in elements. E.g. built-in types are visually
     distinguished from arbitrary types; useful as visual feedback.
  ** Error/warning reporting for (inline) queries.
* More powerful output formatting for semantic querying:
  ** new {{#ask:...}} parser function syntax for inline queries, fully
     compatible with MediaWiki templates, template parameters, and parser
     functions of other extension
  ** more readable inline query structure in #ask parser function,
     printouts separated from query
  ** semantic RSS feeds making feeds from query results via "format=rss"
  ** new printout format "?Category:Name" for #ask
  ** option to hide main column by setting "mainlabel=-", and reinserting
     via print request "?" (only for #ask)
* More expressivity for semantic querying:
  ** support for subproperties,
  ** improved equality resolution (redirects),
  ** support for disjunctions,
  ** inequality check for datavalues ("[[property::!value]]")
  ** optional pattern matching for string values ("[[property::~Semant*]]")
  ** automatic sorting on sort-parameter (no additional condition needed)
* New/improved datatypes:
  ** Type:Page for explicitly specifying properties that are "relations"
  ** better media support in Type:Page: special treatment of Image: and Media:
  ** Type:Number as universal replacement for Type:Integer and Type:Float
  ** Type:URL as universal replacement for old Type:URL and Type:URI
  ** Type:Geographic coordinates completely rewritten. More input formats
     supported, more liberal parsing to accept most inputs
  ** special property "allows value" works for all types
  ** display units are now easier to select via property "display units"
  ** Improved data display: URL-links and tooltips work for queries results
     and on special pages
* Improved special pages:
  ** simpler interface for Special:Ask, hide query when using "further results" link
  ** hints and warning for property usage/declaration in Special:Properties
  ** extra information and warnings for types on Special:Types
  ** Special:SemanticStatistics as faster replacement for earlier "ExtendedStatistics"
* Better internationalisation:
  ** updates in all translation files
  ** new translations to Dutch, Chinese (tw/ch), Korean (beta)
  ** alias strings for all SMW elements; English labels are allowed in all
     languages, names of old SMW elements still work as aliases for their
     replacements.
* New experimental n-ary properties, allowing property values to consist of
  a list of entries.
* Ontology import re-enabled (simple annotation import)
* Maintenance script SMW_refreshData now can rebuild all SMW data structures, fixing
  even exotic database problems on most sites.
* New maintenance script for announcing site to Semantic Web crawlers.
* Support for upcoming MediaWiki 1.12
* Improved APIs and various new hooks to simplify the life of SMW extension developers.
* Many bugfixes.

Other changes for SMW1.0 include:
* Type:Enum became obsolete, since all types now suppport "allows value", but it
  remains an alias for Type:String.
* Some configuration options for LocalSettings.php have changed. Read INSTALL
  for details on how to upgrade from your old installation.


== Semantic MediaWiki post 1.0RC3 ==

* Support for dynamic, query-generated RSS-feeds via query format "rss".
* Optional query feature for pattern matching in Type:String property values.
* Correct dynamic sorting of result tables, even for dates and numerical values.
* Thumbnail images when displaying property values from Image namespace.
* Simplified use of "sort" parameter in queries.
* Support for upcoming MediaWiki 1.12 (major parser changes).
* More efficient link generation in query results. Link all query results by
  default now.
* Maintenance script SMW_refreshData now can rebuild all SMW data structures,
  fixing even exotic database problems on most sites.
* New maintenance script for announcing site to Semantic Web crawlers.
* Various bugfixes.

== Semantic MediaWiki 1.0RC3 ==

* New method for integrating inline queries via #ask parser function, separation of
  query and printout requests, full compatibility with templates.
* New layout for Special:Ask to reflect #ask structure.
* New printout option: "?Category:Name" to ask for membership in that category.
* Re-enabled service links (e.g. use [[provides service::online maps]] on any page of
  a property to Type:Geographic coordinates).
* Re-enabled Type:Boolean.
* Prototype translation for Korean (still alpha).
* Various minor bugfixes.

== Semantic MediaWiki 1.0RC2 ==

* Experimental Postgres support.
* More liberal parsing for geographic coordinates, most user inputs accepted now.
* Improved URL datatype: better linking behavior, tolerant towards Unicode-URLs.
* Significantly improved performance for RDF export.
* Complete translations for Fr, Zh-tw, and Zh-ch added.
* Various minor bugfixes.

== Semantic MediaWiki 1.0RC1 ==

* Simplified semantic annotations: just one kind of annotation ("Property").
* Significant speedup (both server and network load substantially reduced).
* Prettier and easier to understand interfaces:
  ** New tooltips that work on both normal and special pages.
  ** Simplified factbox layout, with all properties in alphabetic order.
  ** Inline warnings to simplify trouble shooting with annotations.
  ** Improved, more helpful and informative warning and error messages.
  ** Highlighting for built-in elements. E.g. built-in types are visually
     distinguished from arbitrary types; useful as visual feedback.
  ** Error/warning reporting for (inline) queries.
* Alias strings for all SMW elements. English labels are allowed in all
  languages, names of old SMW elements still work as aliases for their
  replacements.
* More expressivity for semantic querying:
  ** support for subproperties,
  ** improved equality resolution (redirects),
  ** support for disjunctions,
  ** inequality check for datavalues ("[[property::!value]]")
* New/improved datatypes:
  ** Type:Page for explicitly specifying properties that are "relations"
  ** Type:Number as universal replacement for Type:Integer and Type:Float
  ** Type:URL as universal replacement for old Type:URL and Type:URI
  ** Type:Geographic coordinates completely rewritten. More input formats
     supported now (e.g. coordinates without "," separating Lat and Long)
  ** special property "allows value" works for all types
  ** display units are now easier to select via property "display units"
  ** Improved data display: linked URLs and tooltips work for queries and
     special pages
* Improved maintenance special pages:
  ** Hints and warning for property usage/declaration in Special:Properties
  ** Extra information and warnings for types on Special:Types
  ** Special:SemanticStatistics as faster replacement for earlier "ExtendedStatistics"
* New experimental n-ary properties, allowing property values to consist of
  a list of entries.
* Ontology import re-enabled (simple annotation import)
* Dutch translation added (by Siebrand Mazeland)
* Improved APIs and various new hooks to simplify the life of SMW extension developers.
* Many bugfixes.

Other changes for the RC1 include:
* No more support for Type:Boolean. Will be re-enabled later.
* Type:Enum became obsolete, since all types now suppport "allows value", but it
  remains an alias for Type:String.
* Service links are not working in this Release Candidate yet, especially coordinate
  values do not link to maps yet. This will reappear before SMW1.0 final.


== Semantic MediaWiki 0.7 ==

* New browsing interface for semantic data: Special:Browse
* Improved simple searching interfaces, making the old Special:Searchtriple
  obsolete by various new interlinked special pages.
* New formatting options for inline queries:
** Template-based formatting for formats "list" and "template"
** Transclusion of result articles with format "embedded"
** Counting query results with format count.
* New datatype for enumerated string values (Type:Enum).
* Pages of attributes and relations now list all uses of these properties.
* Pages of types now list all attributes using a type.
* New Special:WantedRelations showing relations that are used but have no page.
* Improved support for arbitrary symbols in string values, including wiki links
  and HTML entities (now correct in RDF).
* Improved headers for query tables, with sort icon and link to attribute/relation
  separated.
* Added maintenance script to rebuild semantic data, thus fixing any inconsistencies
  in the semantic database that may have occurred earlier or due to text-only imports
  of pages.
* Translations to further languages, including Hebrew (right-to-left).
* New cleaner storage implementation, allowing to run MediaWiki parsertests with the
  option $smwgDefaultStore = SMW_STORE_TESTING; in LocalSettings.php.
* MediaWiki-1.10-Ready ;-)
* Simplified installation (no more manual patching with MediaWiki 1.10).
* Many bugfixes.

== Semantic MediaWiki 0.6 ==

* New Special:Ask for directly browsing query results and for testing queries.
* New output format "timeline" for inline queries that deal with dates. Available
  parameters are: timelinestart (name of start date attribute), timelineend (name
  of end date attribute, if any), tiemlinesize (CSS-encoded height), timelinebands
  (comma-separated list of bands such as DAY, WEEK, MONTH, YEAR, ...), and
  timelineposition (one of start, end, today, middle).
* Complete RDF export is now possible with a maintenance script, which can e.g. be
  run periodically on a server to create RDF files.
* New "service links" feature: any attribute can provide configurable links to
  online services. As a special case, the map-services of geo-coordinates are now
  fully configurable.
* Inline queries now link to life search for further results if not all results
  were shown inline.
* The formatting code for inline queries was rewritten to become more powerful.
  For instance, multi-property outputs in list format will never produce empty
  parentheses now.
* RDF-export code is cleaner and some further OWL DL incompatibilities are caught.
* RDF-export now can generate browsable RDF (with backlinks) even for Category
  pages.
* Improved headers for sorting tables. Sort icon now visible even if no text is
  shown in header.
* Many bugfixes.

== Semantic MediaWiki 0.5 ==

* Customised datatypes for unit conversion: it is now possible to create customised
  linear unit conversions by appropriate statements on type articles. This also
  enables full localisation of all units of measurement.
* Customized display of units: every attribute can now decide which units to display
  in factbox and query results. Internally, values are still normalised, but users
  can adjust the view to the most common description of some attribute.
* Support for importing vocabularies from external ontologies. For instance, elements
  of the wiki can now be mapped to the FOAF ontology during export. The import is
  controlled by whitelist-like message articles.
* New attribute datatypes for URLs and URIs, some of which can be exported in RDF as
  ObjectProperties. A blacklist is used to prevent technically problematic URIs from
  being used there (e.g. most don't want to use OWL language elements as data).
* New attribute datatype for temperature, since this cannot be defined by a linear
  custom unit conversion.
* Improved Special:Relations and Special:Attributes, including a quicklink to searching
  occurrences of some annotation.
* Unit support for inline queries. Desired output unit can be adjusted through query.
* Improved code layout, using object-orientation features of PHP5.
* Many bugfixes.

== Semantic MediaWiki 0.4.3.2 ==

This fixes another small bug that prevented the limit parameter in queries to work
properly.

== Semantic MediaWiki 0.4.3.1 ==

This fixes a small but critical bug that prevented queries for non-numeric attribute
values to work properly.

== Semantic MediaWiki 0.4.3 ==

Semantic MediaWiki 0.4.3 is an intermediate release that greatly improves the
performance and features of inline queries. It also includes some major code
cleanups and various bugfixes.

An updated documentation of the current inline queries is (soon) to be found at
http://semantic-mediawiki.org/wiki/Help:Inline_queries

== Semantic MediaWiki 0.4 ==

Semantic MediaWiki 0.4 includes the following new features:

* Support for inline queries: it is now possible to <ask> queries in
  articles, the answers of which are included into the displayed page.
  Conjunctions and nesting of queries is supported. Datatype queries
  for values above or below some threshold are possible. Outputs can be
  displayed in many different formats, including bulleted and numbered
  lists, tables with intercative (JScript) sorting (credits go to
  Stuart Langridge for www.kryogenix.org/code/browser/sorttable/), and
  plain text. See http://semantic-mediawiki.org/wiki/Help:Inline_queries
  for documentation.
* Improved output for Special:Relations and Special:Attributes: usage of
  relations and attributes is now counted
* Improved ontology import feature, allowing to import ontologies and to
  update existing pages with new ontological information
* Experimental support for date/time datatype
* More datatypes with units: mass and time duration
* Support for EXP-notation with numbers, as e.g. 2.345e13. Improved number
  formatting in infobox.
* Configurable infobox: infobox can be hidden if empty, or switched off
  completely. This also works around a bug with MediaWiki galeries.
* Prototype version of Special:Types, showing all available datatypes with
  their names in the current language setting.
* "[[:located in::Paris]]" will now be rendered as "located in [[Paris]]"
* More efficient storage: changed database layout, indexes for fast search
* Code cleaned up, new style guidelines
* Bugfixes, bugfixes, and some more bugfixes

Semantic MediaWiki 0.4 has not been tested on MediaWiki below 1.6.1 and might
fail to operate correctly in this case. Some functions explicitly use code
that was introduced in 1.6.

== Semantic MediaWiki 0.3 ==

Changes by mak (0.3, 06 Apr 2006):

* Compatibility updates for MediaWiki 1.6

Changes by denny/mak (0.3, 25 Mar 2006):

* Internal: improved management of special properties
* RDF export: OWL conformant export of all available content data, including category information
* RDF export: recursive export, "streaming"
* UI: further internationalization, internationalized float number format (decimal separator)
* UI: new infobox section for recognized special properties
* new Specials to show all relations/attibutes
* new experimental Special to import data from existing OWL/RDF ontologies
* new special property "equivalent URI" that allows to map wiki concepts to URIs in other ontologies

Changes by kai/mak (0.3preview, 15 Mar 2006):

* Internal: new internal storage management; cleaner, more flexible, and more efficient
* Internal: new internal type registration API
* Internal: new internal management for special properties (e.g. 'has type')
* Internationalization: almost complete; namespaces, special properties (e.g. 'has type'), datatype labels
* RDF export: support for multiple mimetypes (rdf+xml and xml); needed for Piggybank
* RDF export: support for bulk export
* RDF export: XSD datatypes and correct instance classification (rdf:type)
* UI: extended Special:SMWAdmin to convert data from old internal datatable to new format
* UI: duplicate attribute values eliminated in infobox
* UI: types can switch off quicksearch links
* UI: more human-oriented error mesages ;-)
* UI: service links for infobox and search
* new datatype for geographic coordinates, accepting many kinds of coordinate inputs, and providing links to standard mapsources
* Simple semantic search supports imprecise search again

Changes by mak (0.2c, 9 Mar 2006):

* added basic language support functionality
* improved installation process (SMW_LocalSettings.php, simpler patching for Setup.php)

Changes by mak (0.2c, 1 Mar 2006):

* RDF Export enabled
* more CSS and an icon to show RDF download link on pages

Changes by kai/mak (0.2c, Feb 2006):

* Added new custom stylesheet and JScript (kai/mak)
* New JScript tooltips (kai)
* New style for infobox search items (mak)

Changes by mak (0.2c, Feb 2006):

* Added new Special:SMWAdmin that allows relatively painless upgrade
  from versions <=0.2 where no namespaces were used.
* Added support for moving pages with its stored triples.
* BUGFIX: triples in articles with SQL-hostile symbols (e.g. ') are
  now working.

== Semantic MediaWiki 0.2b ==

Changes by mak (0.2b, Jan 2006):
* Changed directory structure for more clarity, easier installation
  and upgrade.
* Now using custom namespaces for Relations, Attributes, and Types,
  and their talks.
* Semantic features can be switched on or off for each namespace
  individually.
* Registered extension for MediaWiki's "Special:Version".
* BUGFIX: Configuration now takes fixed servername to use in storing
  URIs. Before, different access methods (e.g. direct IP vs. servername)
  generated different URIs.
* BUGFIX: Attributes that could not be parsed now do not generate
  triples with empty object in our database.

Changes by mak (0.2a, 4 Dec 2005):
* Attribute values are now correctly stored and retrieved.
* Special SearchTriple greatly enhanced, such that queries for
  attributes become possible (including unit conversion).
* Links from attributes in infobox to the new search form.
* Major code cleanup: SMW_AttributeStore.php now is called
  SMW_SemanticData.php and managemes all types of semantic
  data, including printout and storage. SMW_Hooks.php was freed
  of all code with similar purpose. Look-up of attribute types
  was moved from SemanticData to Datatype.

Changes by mak (0.1b, 1 Dec 2005):
* Reworked internal data representation. All information now is
  properly encoded in URIs and decoded for display. This is an
  important prerequisite for storing attributes and auxilliary
  triples, which otherwise could not be distinguished from the
  relational information.
* New Special SearchTriple to replace the current SearchSemantic,
  which is currently only half functional since it believes that
  the database contains only simple names for articles, but not
  full URIs.
* Minor adjustments in handling of namespaces: namespaced aritcles
  now properly work as subjects and are displayed with namespace in
  in the infobox.

Changes by mak (0.1b, 19 Nov 2005):

* New type management; attributes can now be declared by creating
  relations of type "has type" inside their articles (Attribute:X).
  Possible targets are the builtin types (Type:String, Type:Geographic
  length, etc.).
* New internal method SMWGetTriples for directly retrieving triples
  from the storage. Accepts subject, predicate, object pairs, where
  any two can be left out.
* Improved layout for infoboxes.

Changes by mak (0.1b, 13 Nov 2005):

* added support for separator "," in data numbers,
* added tooltips for unit conversion.

Changes by mak (0.1b, 17 Oct 2005):

* added attribute support [[attribute name:=value|alternative text]];
  currently, parsing these within the article works, including an
  info box at the bottom; however, assignment from attributes to
  datatypes is still hardcoded and attribute-annotations are neither
  stored as triples nor are they supported in search,
* added basic type support for STRING, INTEGER, and FLOAT,
* added framework for unit conversion and first unit support: unit
  conversion is achieved by callback functions, so that adding types
  for new units boils down to writing a single unit conversion function,
* code split into several files for easier colaboration of developers,
* new naming convention "SMW"-prefix for all top level code elements of
  the extension,
* moved main storage methods to SMW_Storage.php, this should simplify
  the conversion to another storage backend (triplestore),
* moved stripping of semantic relations to SMW_Stripsemantics.php;
  if this feature is desired, this file needs to be updated slightly
  (also to include semantic attributes) and its methods connected to
  their appropriate hooks as done in 0.1

Changes by mak (0.1a, 4 Oct 2005):

* moved parsing process to ParserAfterStrip to support <nowiki>; it
  has to be done even later to support template inclusion properly,
* changed process of storing/retrieving: no more stripping of semantic
  relations before saving -- the annotations now appear exactly where
  the user has put them, keeping them easier to read and maintain,
* parse only once: saving is based on the relations that were retrieved
  during the earlier call of parse(); for this to work, saving needs to
  be deferred -- it is currently done at ArticleSaveComplete [should
  there be a dedicated hook for deferred saving?],
* enabled removal of semantic links on article deletion,
* changed layout of semantic links factsheet, including some neat grouping
  feature.

== Semantic MediaWiki 0.1 ==

This is a pre-alpha version of the Semantic MediaWiki extensions.
It includes:

* support for typed links [[link type::link target|link label]],
* rendering of fact sheet on semantic relations at article bottom,
* Special:SearchSemantic (alpha), featuring autocompletion for
  link types.
