<?php

/**
 * create a viewport emulator page
 *
 * Host is always http://wiki.selfhtml.org
 * Path is always /extensions/Selfhtml/example.php/Beispiel:%s
 * File parameter gets appended to Host/Path
 *
 */

define('VIEWPORTEMULATOR_JS_PATH', '/extensions/Selfhtml/js/');

class ViewportEmulator {

	/**
	 * function to assemble final HTML document
	 */
	public  static function compose() {
		$html = <<<HTML
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8" />
		<title>SELFHTML Viewport-Emulator</title>
		<script type="text/javascript" src="{VIEWPORTEMULATOR_JS_PATH}jquery/jquery-1.11.1.min.js"></script>
		<script type="text/javascript" src="{VIEWPORTEMULATOR_JS_PATH}viewport-emulator.js"></script>
		<style>
			body {
				background-color: #aaa;
				height: 100%;
				margin: 0;
				padding: 0;
				text-align: center;
				width: 100%;
			}
			iframe {
				background-color: #fff;
				border: 50px solid black;
				margin: 20px auto 0;
				border-radius: 50px;
			}

			::-webkit-scrollbar { /* gesamte Scrolleiste */ }
			::-webkit-scrollbar-button { /* Pfeil-Buttons */ }
			::-webkit-scrollbar-track { /* Bereich für den Schieberegler */ }
			::-webkit-scrollbar-thumb { /* Schieberegler */ }
			::-webkit-scrollbar-corner { /* Größenregler (bei TEXTAREA sichtbar) */ }
		</style>
	</head>
	<body>
		<h1>SELFHTML Viewport-Emulator</h1>
		<p>Ohne aktiviertes JavaScript sehen Sie hier nur diesen Hinweistext.</p>
	</body>
</html>

HTML;

		header('Content-Type: text/html; charset=utf-8');

		echo str_replace(
			'{VIEWPORTEMULATOR_JS_PATH}',
			VIEWPORTEMULATOR_JS_PATH,
			$html
		);
	}
}

chdir(isset($_SERVER["MW_INSTALL_PATH"]) ? $_SERVER["MW_INSTALL_PATH"] : '../..');
require 'includes/WebStart.php';

ViewportEmulator::compose();
