<?php

function makeTable ($ar) {
	$str = <<<TABLE
			<table>
				<thead>
					<tr>
						<th>Schlüssel</th>
						<th>Wert</th>
					</tr>
				</thead>
				<tbody>

TABLE;

	foreach ($ar as $key => $value) {

		$str .= sprintf(
			"\t\t\t\t\t<tr>\r\n"
			. "\t\t\t\t\t\t<td>%1\$s</td>\r\n"
			. "\t\t\t\t\t\t<td>%2\$s</td>\r\n"
			. "\t\t\t\t\t</tr>\r\n",
			htmlspecialchars($key),
			htmlspecialchars($value)
		);
	}

	$str .= <<<TABLE
				<tbody>
			</table>

TABLE;

	return $str;
}

?><!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8" />
		<link rel="stylesheet" type="text/css" media="all" href="http://wiki.selfhtml.org/extensions/Selfhtml/example.php/Beispiel:SELFHTML-Beispiel-Grundlayout.css" />
		<style>
			th, td {
				background: white;
				padding: 0.2em 1em;
			}
		</style>
	</head>
	<body>
		<h1>Empfangene Daten</h1>
		<main role="main">
			<p>Der Server hat Ihre Anfrage erhalten.</p>
			<h2>Daten via POST-Methode</h2>
<?php

	if (!empty($_POST)) {

		echo makeTable($_POST);

	} else {

		echo "\t\t\t<p>Keine POST-Daten erhalten.</p>\r\n";
	}

?>			<h2>Daten via GET-Methode</h2>
<?php

	if (!empty($_GET)) {

		echo makeTable($_GET);

	} else {

		echo "\t\t\t<p>Keine GET-Daten erhalten.</p>\r\n";
	}

	if (array_key_exists('HTTP_REFERER', $_SERVER)) {

		printf(
			"\t\t\t<p>Sie kamen von dieser "
			. '<a href="%1$s">vorherigen Seite</a>'
			. ".</p>\r\n",
			htmlspecialchars($_SERVER['HTTP_REFERER'])

		);
	}

?>		</main>
	</body>
</html>