jQuery(function($) {

	var settings = {
		/**
		 * Seitenauswahl
		 * Erscheint in Selectbox
		 */
		pages: [
			"selfhtml.org",
			"blog.selfhtml.org",
			"forum.selfhtml.org",
			"wiki.selfhtml.org"
		],

		/**
		 * Liste der Auflösungen
		 * Index ist die Auflösung im Querformat, Value die Beschreibung
		 */
		resolutions: {
			"480x320": "Mobile",
			"800x600": "Small tablet",
			"1024x600": 'Tablet 7\u2033',
			"1280x800": 'Tablet 10\u2033',
			"1024x768": "iPad mini",
			"2048x1536": "iPad mini Retina",
			"1024x768": "iPad 2",
			"2048x1536": "iPad Air"
		},

		/**
		 * Defaultauflösung
		 * Greift nur, wenn localStorage keinen anderen Wert hat.
		 */
		resolution: "1024x600"
	};

	/**
	 * Viewport-Emulator Script
	 */
	new function () {
		var alignmentEl = $("<select>"),
			iframeEl = $("<iframe>"),
			pageEl = $("<input>"),
			pages = $("<datalist>"),
			reloadEl = $("<button>(re)load</button>"),
			resolutionEl = $("<select>");

		function changeResolution () {
			var a = (alignmentEl.val() === "landscape"),
				res = resolutionEl.val().split("x");

			iframeEl.css({
				width: res[a ? 0 : 1] + "px",
				height: res[a ? 1 : 0] + "px"
			});

			// save user preference in localStorage
			localStorage.setItem(
				"viewport-emulator_alignment",
				alignmentEl.val()
			);

			localStorage.setItem(
				"viewport-emulator_resolution",
				resolutionEl.val()
			);
		}

		/* fill selects with options
		 * and pre-select them with preferences from localStorage */
		["alignment", "page", "resolution"].forEach(function (t) {
			var v = localStorage.getItem("viewport-emulator_"+t);

			if (v) {
				settings[t] = v;
			}

			switch (t) {

				case "alignment":
					$.each(["landscape", "portrait"], function (i, s) {
						var el = $("<option>"+s+"</option>");

						if (s === settings.alignment) {
							el.prop("selected", true);
						}

						alignmentEl.append(el);
					});

					alignmentEl.on("change", function () {
						changeResolution();
					});
				break;

				case "page":
					pageEl.attr({
						list: "pages",
						type: "search"
					});

					if (location.href.match(/\/viewport-emulator\.php\/Beispiel:/)) {

						pageEl.val(location.href.replace(
							/\/viewport-emulator\.php\//,
							"/example.php/"
						));

					} else {

						pageEl.val(settings.pages[0]);
					}

					pages.prop("id", "pages");

					settings.pages.forEach(function (s) {
						pages.append('<option value="'+s+'">');
					});
				break;

				case "resolution":
					$.each(settings.resolutions, function (res, txt) {
						var el = $("<option>"+txt+" ("+res+")</option>");

						el.val(res);

						if (res === settings.resolution) {
							el.prop("selected", true);
						}

						resolutionEl.append(el);
					});

					resolutionEl.on("change", function () {
						changeResolution();
					});
				break;
			}
		});

		// rewrite <body> DOM
		$("body").html("<header>").find("header")
			.append(pageEl)
			.append(pages)
			.append(reloadEl)
			.append(resolutionEl)
			.append(alignmentEl);

		$("body").append(iframeEl);

		// enable reload button
		reloadEl.on("click", function () {
			var url = pageEl.val();

			if (!url.match(/^http/i)) {
				url = "http://" + url;
			}

			iframeEl.prop("src", url);
		});

		// let's go!
		changeResolution();

		if (window.viewportEmulatorData) {

			// load data into iframe document
			window.setTimeout(function () {
				var doc = iframeEl.get(0).contentDocument;

				doc.open();
				doc.write(decodeURIComponent(window.viewportEmulatorData));
				doc.close();
			}, 100);

		} else {

			reloadEl.trigger("click");
		}
	};
});
