// frickl - fsFiddle-like functionality
jQuery(function($) {
	var baseURL = location.href.replace(/\/frickl\.php.*/, "/"),
		editors = {},
		p,
		view = $('<iframe id="view" src="about:blank">');

	function changeLayout (val) {
		var b = $("body"), c;

		// change layout
		c = b.attr("class");

		if (c) {
			// remove any class names that start with "frickl-layout-"
			b.attr(
				"class",
				c.replace(/ ?frickl-layout[^ ]*/, "")
			);
		}

		// store choice in localStorage['frickl-layout']
		localStorage.removeItem('frickl-layout');

		if (val != "") {
			b.addClass(val);
			localStorage.setItem('frickl-layout', val);
		}
	}

	function deSelectEditor (ed) {
		if (ed && ed.clearSelection) {
			ed.clearSelection();
			ed.navigateTo(0, 0);
		}
	}

	function preSelectLayout () {
		var c = "", s = $("#layout select");

		// do anything?
		if (s.length && window.localStorage) {

			c = localStorage.getItem('frickl-layout');

			$.each(s.prop("options"), function (i, o) {

				if (o.value == c) {
					s.prop("selectedIndex", i);
					s.trigger("change");
				}
			});
		}
	}

	function resizeEditors () {
		var ed, visible = [];

		for (ed in editors) {
			if ($("#editor_"+ed).prop("checked")) {
				visible.push(editors[ed]);
			}
		}

		if (!$("body").hasClass("frickl-layout-stacked")) {

			if (visible.length > 0 && visible.length < 3) {

				document.body.className = [
					"frickl-layout-single",
					"frickl-layout-double"
				][visible.length -1];

			} else {

				document.body.className = "";
			}

			visible.forEach(function (ed) {
				ed.resize();
			});

		} else {

			visible.forEach(function (ed) {
				ed.resize();
			});
		}
	}

	function resizeFrickl () {
		window.setTimeout(function () {
			$("main > article:last-child").height(Math.ceil(
				$(window).height()
				- $("main > article:first-child").height()
				- $("main > article:last-child").offset().top
			));

			resizeEditors();
		}, 500);
	}

	function tidy (data, t) {
		var opts = {
			indent_size: 1,
			indent_char: "\t",
			max_preserve_newlines: -1,
			preserve_newlines: false,
			keep_array_indentation: true,
			break_chained_methods: true,
			indent_scripts: "normal",
			brace_style: "collapse",
			space_before_conditional: true,
			unescape_strings: true,
			jslint_happy: true,
			end_with_newline: true,
			wrap_line_length: 80
		};

		switch (t) {
			case "css":
				data = css_beautify(data, opts);
			break;

			case "html":
				data = html_beautify(data, opts);
			break;

			case "javascript":
				data = js_beautify(data, opts);
			break;
		}

		return data;
	}

	function updateView () {
		var doc = view.get(0).contentDocument,
			html = "<head><title>Frickl - SELFHTML-Wiki</title>",
			w;

		if ($("#external_window").prop("checked")) {
			w = window.open(
				"about:blank",
				"new_result",
				"width=" + screen.availWidth
				+ ",height=" + screen.availHeight
				+ ",menubar=yes,scrollbars=yes,statusbar=yes,toolbar=yes"
			);
			doc = w.document;
		}

		["css", "javascript", "html"].forEach(function (t) {
			var code = editors[t].getValue();

			switch(t) {

				case "css":
					if (code.length > 0) {
						html += '<style type="text/css" media="screen">\n'
							+ code
							+ "\n</style>";
					}
				break;

				case "html":
					html += "</head><body>\n"
						+ code
						+ "\n</body>";
				break;

				case "javascript":
					// inject jQuery first
					html += '<script type="text/javascript" src="'
						+ $('script[src*="/jquery/"]').attr("src")
						+ '"></script>';

					if (code.length > 0) {
						html += '<script type="text/javascript">'
							+ "//<![CDATA[\n"
							+ code
							+ "\n//]]></script>";
					}
				break;
			}
		});

		html = tidy("<!DOCTYPE html><html>"+html+"</html>", "html");

		doc.open();
		doc.writeln(html);
		doc.close();

		return html;
	}

	// setup layout
	$("head").append(
		'<link href="'
		+ baseURL
		+ 'css/frickl.css" media="screen" rel="stylesheet" type="text/css" />'
	);

	// setup template
	$("body").html(
		'<main>'
			+ '<article>'
				+ '<h1>&lt;!selfhtml.frickl/&gt;</h1>'
				+ '</article>'
			+ '<article></article>'
		+ '</main>'
		+ '<nav>'
			+ '<ul></ul>'
		+ '</nav>'
	);

	// setup some buttons
	$("body > nav > ul")
	.append(
		$('<li id="run-result">Ergebnis aktualisieren </li>')
		.on("click", function () {
			updateView(1);
		})
		.append(
			$("<ul>").append(
				$('<li><label for="external_window">'
					+ '<input id="external_window" type="checkbox" />'
					+ 'in neuem Fenster anzeigen</label></li>'
				)
			)
			.append(
				$("<li>im Viewport-Emulator testen</li>")
				.on("click", function (e) {
					var data = encodeURIComponent(updateView()),
						w = window.open(
						"about:blank",
						"viewport_emulator",
						"width=" + screen.availWidth
						+ ",height=" + screen.availHeight
						+ ",menubar=yes,scrollbars=yes,statusbar=yes,toolbar=yes"
					);

					e.stopPropagation();

					doc = w.document;
					doc.open();
					doc.write(
						'<!DOCTYPE html><html><head><meta charset="utf-8" />'
						+ '<title>Viewport-Emulator</title>'
						+ '<script type="text/javascript" src="'+baseURL+'js/jquery/jquery-1.11.1.min.js"></script>'
						+ '<script type="text/javascript" src="'+baseURL+'js/viewport-emulator.js"></script>'
						+ '<script type="text/javascript">//<![CDATA\n'
						+ 'window.viewportEmulatorData = "'+data+'";'
						+ '//]]></script>\n'
						+ '<style>\n'
						+ 'body { background-color: #aaa; height: 100%; margin: 0; padding: 0; text-align: center; width: 100%; }\n'
						+ 'iframe { background-color: #fff; border: 50px solid black; margin: 20px auto 0; border-radius: 50px; }\n'
						+ '</style>\n'
						+ '</head><body></body></html>'
					);
					doc.close();
				})
			)
			.on("click", function (e) {
				e.stopPropagation();
			})
		)
	)
	.append(
		$('<li id="tidy">Code aufräumen</li>')
		.on("click", function () {
			// js-beautify all code
			["css", "html", "javascript"].forEach(function (t) {
				editors[t].setValue(
					tidy(editors[t].getValue(), t)
				);

				deSelectEditor(editors[t]);
			});
		})
	)
	.append(
		$('<li id="show-editors">Editoren <ul></ul></li>')
	)
	.append(
		$('<li id="layout">Layout</li>')
		.append(
			$("<ul>")
			.append(
				$("<li>")
				.append(
					$("<label>")
					.append(
						$("<select>")
						.on("change", function (e) {
							changeLayout(e.target.value);
						})
						.append(
							'<option value="">Standard</option>'
							+ '<option value="frickl-layout-stacked">untereinander</option>'
						)
					)
				)
			)
		)
	);

	preSelectLayout();

	// setup code editors
	["html", "css", "javascript"].forEach(function (t) {

		editors[t] = ace.edit(
			$('<div id="'+t+'">')
			.on("mouseover", function () {
				$("#"+t).addClass("focus");
			})
			.on("mouseout", function () {
				if (!editors[t].isFocused()) {
					$("#"+t).removeClass("focus");
				}
			})
			.appendTo("main > article:last-child").get(0)
		);

		editors[t].setTheme("ace/theme/chrome");
		editors[t].getSession().setMode("ace/mode/"+t);
		editors[t].getSession().setUseWorker(false);
		editors[t].getSession().setUseWrapMode(true);

		// pseudo labels
		editors[t].on("focus", function () {
			$("#"+t).addClass("focus").addClass("active");
		});

		editors[t].on("blur", function () {
			$("#"+t).removeClass("focus").removeClass("active");
		});

		// hide/show editor options
		$("#show-editors ul").append(
			$('<li><label for="editor_' + t + '">'
				+ '<input id="editor_' + t + '" type="checkbox" '
				+ (!window.fricklData
					|| (window.fricklData
						&& t in window.fricklData
						&& window.fricklData[t].length > 0
					)
					? 'checked="checked" '
					: ''
				)
				+ '/>'
				+ {
					css: 'CSS',
					html: 'HTML',
					javascript: 'JavaScript'
				}[t]
				+ '</label></li>'
			)
		);

		// enable show/hide functionality
		$("#editor_" + t).on("change", function (e) {

			if ($(e.target).prop("checked")) {

				$("#" + t).show();

			} else {

				$("#" + t).hide();
			}

			resizeEditors();
		});

		$("#editor_" + t).trigger("change");
	});

	// setup result frame
	$("main > article:last-child").append(view);

	resizeFrickl();

	// load data into editors
	if (!window.fricklData) {
		// defaults
		window.fricklData = {
			css: 'body {\n\tbackground: lightgreen;\n}\n\n.js {\n\tbackground: #fcc;\n}\n',
			html: '<article>\n\t<h1>Überschrift</h1>\n\t<p>Textabsatz...</p>\n</article>\n',
			javascript: 'jQuery(document).ready(function ($) {\n'
				+ '\t$(\'<p class="js">JavaScript: Alles fertig geladen!</p>\')\n'
				+ '\t.appendTo("body");\n});\n'
		};
	}

	for (p in window.fricklData) {

		if (p in editors) {

			editors[p].setValue(tidy(window.fricklData[p], p));
			deSelectEditor(editors[p]);
		}
	}

	/* enable workers to display annotations - but only if changes have
	 * been made to the respective editor's contents */
	["css", "html", "javascript"].forEach(function (t) {
		var s;

		if (t in editors) {

			s = editors[t].getSession();

			s.on("change", function () {
				if (!s.getUseWorker()) {
					s.setUseWorker(true);
				}
			});
		}
	});

	updateView();

	$(window).on("resize", function () { resizeFrickl(); });

	// offer "return to page" button?
	if (window.location.search.match(/(\?|&)r=([^&]+)/)) {
		$("nav > ul:first-child")
		.append(
			'<li id="return"><a href="'
			+ window.location.search.replace(/.*(\?|&)r=([^&]+).*/, "$2")
			+ '">vorherige Seite</a></li>'
		);
	}

	// offer download button to save result HTML file
	if (window.Blob) {
		// add button
		$("#run-result ul").append(
			$("<li>").append(
				$('<a id="download" download>HTML-Datei downloaden</a>')
				.on("click", function (e) {
					var b = new Blob(
						[updateView(true)],
						{
							type: "text/html;charset=utf-8"
						}
					);

					// don't do anything with the result frame now
					e.stopPropagation();

					// try to offer a "save as" dialog
					$(e.target)
					.attr(
						"href",
						URL.createObjectURL(b)
					);
				})
			)
		);
	}
});
