<?php

/**
 * create a jsFiddle-like experimentation page
 *
 * Host is always http://wiki.selfhtml.org
 * Path is always /extensions/Selfhtml/example.php/Beispiel:%s
 * File parameter gets appended to Host/Path
 *
 */

define('FRICKL_JS_PATH', '/extensions/Selfhtml/js/');

class Frickl {

	public  function __construct () {
		//
	}

	/**
	 * function to assemble final HTML document
	 */
	public  function compose() {
		$t = $this;

		$html = $t->getTemplate();
		$data = $t->getExampleData();

		$html = str_replace(
			'window.fricklData = null;',
			sprintf('window.fricklData = %s;', json_encode($data)),
			$html
		);

		header('Content-Type: text/html; charset=utf-8');
		echo $html;
	}

	/**
	 * function to ensure UTF-8 character encoding in a string
	 *
	 * @param str in ISO-8859-1 encoding or UTF-8
	 * @return string in UTF-8 encoding
	 */
	private function ensure_utf8 ($s) {

		if (is_string($s) && !$this->is_utf8($s)) {
			$s = utf8_encode($s);
		}

		return $s;
	}

	/**
	 * function to retrieve requested example file
	 */
	private function getExampleData () {
		$t = $this;

		global $egExampleNamespaces;

		$data = array('css' => '', 'html' => '', 'javascript' => '');

		$title = Title::newFromText(
			preg_replace('~\?.*~', '', ltrim($_SERVER['PATH_INFO'], '/'))
		);

		if ($title instanceof Title
			&& in_array($title->getNamespace(), $egExampleNamespaces)
			&& $title->exists()
			&& preg_match('~(?i)\.html?~', $title->getText())
		) {

			$article = new Article($title);
			$text = ContentHandler::getContentText( $article->getPage()->getRevision()->getContent( Revision::RAW )); //getRawText();
			#$text = $article->getRawText();

			// HTML
			if (preg_match(
				'~(?is).*<body[^>]*>(.*)</body>.*~',
				$text,
				$test
			)) {
				$data['html'] .= $test[1];
			}

			// CSS: <style>
			if (preg_match(
				'~(?is).*<style[^>]*>(.*)</style>.*~',
				$text,
				$test
			)) {
				$data['css'] .= $test[1];
			}

			// CSS: <link rel="stylesheet">
			if (preg_match_all(
				'~(?is)<link[^>]*rel="stylesheet"[^>]*>~',
				$text,
				$test
			)) {

				foreach ($test[0] as $css) {

					$css = preg_replace(
						'~(?i).*(beispiel.*\.css).*~',
						"$1",
						$css
					);

					$file = Title::newFromText($css);

					if ($file instanceof Title
						&& in_array($file->getNamespace(), $egExampleNamespaces)
						&& $file->exists()
					) {
						$css_file = new Article($file);
						$data['css'] .= "\r\n" . //$css_file->getRawText();
							ContentHandler::getContentText($css_file->getPage()->getRevision()->getContent(Revision::RAW));
					}
				}
			}

			// JavaScript: <script>
			if (preg_match_all(
				'~(?is)<script[^>]*>(.*?)</script>~',
				$text,
				$test
			)) {
				foreach ($test[1] as $js) {
					$data['javascript'] .= $js;
				}
			}
		}

		if (empty($data['css'])
			&& empty($data['html'])
			&& empty($data['javascript'])
		) {
			$data = null;
		}

		return $data;
	}

	/**
	 * function to retrieve HTML template for page
	 */
	private function getTemplate () {
		$html = <<<HTML
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8" />
		<title>frickl SELFHTML-Wiki</title>
		<script type="text/javascript" src="{FRICKL_JS_PATH}jquery/jquery-1.11.1.min.js"></script>
		<script type="text/javascript" src="{FRICKL_JS_PATH}ace-min-noconflict/ace.js"></script>
		<script type="text/javascript" src="{FRICKL_JS_PATH}js-beautify/beautify.js"></script>
		<script type="text/javascript" src="{FRICKL_JS_PATH}js-beautify/beautify-css.js"></script>
		<script type="text/javascript" src="{FRICKL_JS_PATH}js-beautify/beautify-html.js"></script>
		<script type="text/javascript">//<![CDATA[
			window.fricklData = null;
		//]]></script>
		<script type="text/javascript" src="{FRICKL_JS_PATH}frickl.js"></script>
	</head>
	<body>
		<main role="main">
			<h1>&lt;!selfhtml.frickl /&gt;</h1>
			<p>Ohne aktiviertes JavaScript sehen Sie hier nur diesen Hinweistext.</p>
		</main>
	</body>
</html>
HTML;
		return str_replace('{FRICKL_JS_PATH}', FRICKL_JS_PATH, $html);
	}

	/**
	 * function to check whether a string has UTF-8 character encoding
	 *
	 * The code for this function has been taken from the
	 * simple_html_dom class:
	 * http://sourceforge.net/projects/simplehtmldom/
	 *
	 * @param str in ISO-8859-1 encoding or UTF-8
	 * @return bool is UTF-8
	 */
	private function is_utf8 ($s) {

        $b = 0;
        $c = 0;
        $bits = 0;

        $len = strlen($s);

        for ($i = 0; $i < $len; $i++) {
            $c = ord($s[$i]);

            if ($c > 128) {

                if (($c >= 254)) { return false; }
                elseif ($c >= 252) { $bits=6; }
                elseif ($c >= 248) { $bits=5; }
                elseif ($c >= 240) { $bits=4; }
                elseif ($c >= 224) { $bits=3; }
                elseif ($c >= 192) { $bits=2; }
                else { return false; }

                if (($i+$bits) > $len) { return false; }

                while ($bits > 1) {
                    $i++;

                    $b = ord($s[$i]);

                    if ($b < 128 || $b > 191) { return false; }

                    $bits--;
                }
            }
        }

        return true;
 	}
}

chdir(isset($_SERVER["MW_INSTALL_PATH"]) ? $_SERVER["MW_INSTALL_PATH"] : '../..');
require 'includes/WebStart.php';

$frickl = new Frickl();
$frickl->compose();
