<?php
chdir(isset($_SERVER["MW_INSTALL_PATH"]) ? $_SERVER["MW_INSTALL_PATH"] : '../..');
require 'includes/WebStart.php';

$title = Title::newFromText(ltrim($_SERVER['PATH_INFO'], '/'));

if ($title instanceof Title
	&& in_array($title->getNamespace(), $egExampleNamespaces)
	&& $title->exists()
) {

	$extension = strrchr($title->getText(), '.');

	switch ($extension) {
		case '.html': 
			header("Content-Type: text/html; charset=utf-8");
			break;
		case '.css':
			header("Content-Type: text/css; charset=utf-8");
			break;
		case '.js': $type = 'javascript';
			header("Content-Type: text/javascript; charset=utf-8");
			break;
		case '.xsl':
			header("Content-Type: application/xml; charset=utf-8");
			break;
		case '.xml': $type = 'xml';
			header("Content-Type: application/xml; charset=utf-8");
			break;

		case '.php':
		case '.perl':
		case '.pl':

		default:
			header("Content-Type: text/plain; charset=utf-8");
	}

	$article = new Article($title);
	$text = ContentHandler::getContentText( $article->getPage()->getRevision()->getContent( Revision::RAW )); //getRawText();
	#$text = $article->getRawText();
/*	
	$replacement = '<html lang="de" class="SELFHTML-Beispiel" ' . 
		'style="background: url(\'//wiki.selfhtml.org/images/9/96/Selfhtml-beispiel-logo.svg\') ' . 
		'no-repeat fixed right 1em top 1em transparent;">';
	echo $extension == '.html' ? preg_replace(array('/<html>/', '/<html lang="de">/'), $replacement, $text, 1) : $text;
*/
	echo $text;
	exit;
}
header("HTTP/1.0 404 Not Found");
?>
<!DOCTYPE html>
<html>
	<head>
	<title>404: Not found</title>
</head>
<body>
	<p>Nothing found. - Nichts gefunden.</p>
</body>
</html>
