<?php
/*
 * SELFHTML-Erweiterung für MediaWiki
 *
 * Diese Erweiterung stellt einige nützliche Dinge bereit, die wir bei
 * SELFHTML im MediaWiki benötigen.
 */

if (!defined( 'MEDIAWIKI')) {
	die( 'This file is a MediaWiki extension, it is not a valid entry point' );
}

define('SELFHTML_VERSION', '2.3');

$wgExtensionCredits['parserhook'][] = array(
	'name' => 'SELFHTML',
	'author' => '[[User:Christian Seiler|Christian Seiler]], [[User:dedlfix|dedlfix]], [[User:Felix Riesterer|Felix Riesterer]]',
	'url' => 'http://wiki.selfhtml.org/',
	'descriptionmsg' => 'selfhtml-desc',
	'version' => SELFHTML_VERSION,
);

$wgExtensionMessagesFiles['SELFHTML'] = __DIR__ . '/SELFHTML.i18n.php';


class SelfhtmlStringUtils {

	public static function Setup () {
		global $wgHooks;
		$wgHooks['ParserFirstCallInit'][] = __CLASS__ . '::SetupFunction';
		$wgHooks['LanguageGetMagic'][]    = __CLASS__ . '::SetupMagic';
	}

	public static function SetupFunction ($parser) {
		$parser->setFunctionHook('strlower', __CLASS__ . '::Lower');
		$parser->setFunctionHook('strupper', __CLASS__ . '::Upper');
		$parser->setFunctionHook('uid', __CLASS__ . '::uid');
		return true;
	}

	public static function SetupMagic (&$magicWords, $langCode) {
		$magicWords['strlower'] = array(0, 'strlower');
		$magicWords['strupper'] = array(0, 'strupper');
		$magicWords['uid'] = array(0, 'uid');
		return true;
	}

	public static function uid () {
		return uniqid('S');
	}

	public static function Lower ($parser, $s) {
		return strtolower($s);
	}

	public static function Upper ($parser, $s) {
		return strtoupper($s);
	}
}


class Selfhtml {

	private static $lock = false;
	private static $fetchedText = null;

	public static function Setup() {
		global $wgHooks;

		// wenn beim Editieren die Vorschau verwendet wird
		$wgHooks['EditPageGetPreviewText'][] = __CLASS__ . '::PreviewText';

		// die gefetchte Version für den Parser-Hook merken
		$wgHooks['ArticleAfterFetchContentObject'][] = __CLASS__ . '::AfterFetch';

		/* wenn der Parser angeworfen wird, beispielsweise bei
		 * expiriertem Cache, action=purge oder alten Revisionen */
		$wgHooks['ParserBeforeStrip'][] = __CLASS__ . '::CommonParsing';

		/* beim Speichern eines bearbeiteten Artikels wird die
		 * gerenderte Form im Cache abgelegt */
		$wgHooks['ArticleSave'][] = __CLASS__ . '::SaveText';

		$wgHooks['ParserFirstCallInit'][] = __CLASS__ . '::SetupFunction';
		$wgHooks['LanguageGetMagic'][] = __CLASS__ . '::SetupMagic';

		// EMFF
		$wgHooks['EditPage::showEditForm:initial'][] = __CLASS__ . '::EditFormBottom';

		// Frickl-Overlay
		$wgHooks['BeforePageDisplay'][] = __CLASS__ . '::FricklOverlay';
	}

	public static function SetupFunction ($parser) {
		$parser->setFunctionHook('emff', __CLASS__ . '::RenderEmff');
		$parser->setFunctionHook('beispielurl', __CLASS__ . '::ExampleUrl');
		$parser->setFunctionHook('viewportemulator', __CLASS__ . '::ViewportEmulator');
		return true;
	}

	public static function SetupMagic (&$magicWords, $langCode) {
		$magicWords['emff'] = array(0, 'emff');
		$magicWords['beispielurl'] = array(0, 'beispielurl');
		$magicWords['viewportemulator'] = array(0, 'viewportemulator');
		return true;
	}

	public static function RenderEmff ($parser) {
		global $wgScriptPath;

		$args = func_get_args();
		array_shift($args);

		$mini = false;
		$micro = false;
		$file = false;

		foreach ($args as $arg) {

			switch (strtolower($arg)) {

				case 'mini':
					$mini = true;
					break;

				case 'micro':
					$micro = true;
					break;

				default:
					$file = $arg;
			}
		}

		if (!$file) {

			$output = sprintf(
				'<span class="error">%s</span>',
				wfMessage('selfhtml-emff-error-no-file')->text()
			);

		} else {

			$title = Title::makeTitleSafe(NS_FILE, $file);
			$file = RepoGroup::singleton()->getLocalRepo()->newFile($title);
			$filename = false;

			if ($file->exists()
				&& $title->getNamespace() == NS_FILE
				&& strtolower(substr($title->getPartialURL(), -4)) == '.mp3'
			) {
				$filename = $file->getViewURL();
			}

			if (!$filename) {

				$output = sprintf(
					'<span class="error">%s</span>',
					wfMessage('selfhtml-emff-error-invalid-file')->text()
				);

			} else {

				$output = sprintf(
					'<object type="application/x-shockwave-flash"'
					. ' data="%s/extensions/Selfhtml/emff/%%s"'
					. ' width="%%s" height="%%s">'
					. '<param name="movie"'
					. ' value="%1$s/extensions/Selfhtml/emff/%%1$s" />'
					. '<param name="FlashVars" value="src=%%s" /></object>',
					$wgScriptPath
				);

				if ($micro) {

					$output = sprintf($output, 'emff_silk_button.swf', 16, 16, $filename);

				} elseif ($mini) {

					$output = sprintf($output, 'emff_silk.swf', 84, 32, $filename);

				} else {

					$output = sprintf($output, 'emff_lila.swf', 200, 55, $filename);
				}
			}
		}

		/* dem Parser erzählen, dass die Datei verwendet wird,
		 * damit sie in den Backlinks auftaucht */
		$parser->mOutput->addImage($title->getDBkey());

		return $parser->insertStripItem($output);
		#return array($output, 'noparse' => true, 'isHTML' => true);
	}

	public static function EditFormBottom ($editPage) {
		$editPage->editFormTextBottom .= wfMessage('selfhtml-edithelp')->parseAsBlock();
		return true;
	}

	public static function PreviewText ($editPage, &$toparse) {
		global $egExampleNamespaces;

		if (self::$lock) {
			return true;
		}

		self::$lock = true;

		if (in_array($editPage->mTitle->getNamespace(), $egExampleNamespaces)) {
			$toparse = self::getTextBeautified($toparse, $editPage->mTitle);
		}

		self::$lock = false;

		return true;
	}

	public static function AfterFetch ($article, &$content) {
		global $egExampleNamespaces;

		$title = $article->getTitle();

		if (in_array($title->getNamespace(), $egExampleNamespaces)) {
			self::$fetchedText = $content->getNativeData();
		}

		return true;
	}

	public static function CommonParsing ($parser, &$text, &$strip_state) {

		if (self::$lock) {
			return true;
		}

		self::$lock = true;

		/* Da das Parsen auch für alle möglichen anderen Texte passiert,
		 * wird der Text mit der gefetchten Version verglichen. */
		if (self::$fetchedText !== null
			&& self::$fetchedText == $text
		) {
			$text = self::getTextBeautified($text, $parser->getTitle());
		}

		self::$lock = false;
		return true;
	}

	public static function SaveText (
		$article, &$user, &$text, &$summary,
		$minor, $watchthis,
		$sectionanchor,
		&$flags, &$status
	) {
		global $egExampleNamespaces, $wgParser;

		if (self::$lock) {
			return true;
		}

		self::$lock = true;

		$title = $article->getTitle();

		if (in_array($title->getNamespace(), $egExampleNamespaces)) {
			$x = $article->prepareTextForEdit(self::getTextBeautified($text, $title));
			$x->newText = $text;
			$x->pst = $wgParser->preSaveTransform($text, $title, $user, ParserOptions::newFromUser($wgUser));
		}

		self::$lock = false;

		return true;
	}

	private static function getTextBeautified ($text, $title = null) {
		$type = 'text';

		if ($title instanceof Title) {

			switch (strrchr($title->getText(), '.')) {
				case '.html':
					$type = 'html5';
					break;

				case '.css':
					$type = 'css';
					break;

				case '.js':
					$type = 'javascript';
					break;

				case '.php':
					$type = 'php';
					break;

				case '.pl':
				case '.perl':
					$type = 'perl';
					break;

				case '.xsl':
				case '.xml':
					$type = 'xml';
					break;
			}
		}

		return sprintf('<source lang=%s>%s</source>', $type, $text);
	}

	public static function ExampleUrl ($parser, $title = null, $text = null) {
		global $egExampleNamespaces, $wgScriptPath;

		if (!$title) {

			$output = sprintf(
				'<span class="error">%s</span>',
				wfMessage('selfhtml-example-error-no-title')->text()
			);

		} else {

			$title = Title::newFromText($title);

			if (!$title || !in_array(
				$title->getNamespace(),
				$egExampleNamespaces
			)) {

				$output = sprintf(
					'<span class="error">%s</span>',
					wfMessage('selfhtml-example-error-invalid-namespace')->text()
				);

			} else {

				$text = $text
					? htmlspecialchars($text)
					: wfMessage('selfhtml-example-linktext')->text();

				$example_file_name = $title->getPrefixedDBkey();

				$output = sprintf(
					'<a class="beispiel_url" href="'
					. '%1$s/extensions/Selfhtml/example.php/%2$s'
					. '">%3$s</a>',
					$wgScriptPath,
					$example_file_name,
					$text
				);

/* Konsens der MV 2015: frickl als default
 *  -> Funktionalität in js/frickl-overlay.js
 *
				// EDIT: "frickl" nur bei HTML-Beispieldateien anbieten
				if (preg_match('~(?i)\.html?$~', $example_file_name)) {

					$output .= sprintf(
						' <a class="frickl_url" href="'
						. '%1$s/extensions/Selfhtml/frickl.php/%2$s'
						. '">%3$s</a>',
						$wgScriptPath,
						$example_file_name,
						wfMessage('selfhtml-frickl-linktext')->text()
					);
				}
 */
			}

			/* dem Parser erzählen, dass das Beispiel verwendet wird,
			 * damit die Backlinks gepflegt werden */
			$parser->mOutput->addLink($title);
		}

		return $parser->insertStripItem($output);
		#return array($output, 'noparse' => true, 'isHTML' => true);
	}

	public static function FricklOverlay (&$out, &$skin) {
		global $wgScriptPath;

		$out->addScriptFile(sprintf(
			'%1$s/extensions/Selfhtml/js/frickl-overlay.js',
			$wgScriptPath
		));

		return $out;
	}

	public static function ViewportEmulator ($parser, $title = null) {
		global $egExampleNamespaces, $wgScriptPath;

		$output = '';

		if ($title) {

			$title = Title::newFromText($title);

			$example_file_name = $title->getPrefixedDBkey();

			if (in_array($title->getNamespace(), $egExampleNamespaces)
					&& preg_match('~(?i)\.html?$~', $example_file_name)
			) {

				$output = sprintf(
					'<a class="viewportemulator_url" href="'
					. '%1$s/extensions/Selfhtml/viewport-emulator.php/%2$s'
					. '">%3$s</a>',
					$wgScriptPath,
					$example_file_name,
					wfMessage('selfhtml-viewport-emulator')->text()
				);
			}

			/* dem Parser erzählen, dass das Beispiel verwendet wird,
			* damit die Backlinks gepflegt werden */
			$parser->mOutput->addLink($title);
		}

		return $parser->insertStripItem($output);
		#return array($output, 'noparse' => true, 'isHTML' => true);
	}

}


SelfhtmlStringUtils::Setup();
Selfhtml::Setup();

