<?php

/* Internationalisation file for SELFHTML extension
*/

$messages = array();

$messages['en'] = array(
	'selfhtml-desc' => 'SELFHTML extras',
	'selfhtml-slogan' => 'The Energy of comprehension',
	'selfhtml-edithelp' => <<<HELP
{| class="selfhtml_quick_syntax_examples"
|+ Examples Wiki Syntax:
! Formatting !! Example
|-
| Heading 2nd level || <code><nowiki>== Title ==</nowiki></code>
|-
| Heading 3rd level || <code><nowiki>=== Title ===</nowiki></code>
|-
| Bold and italic || <code><nowiki>'''bold'''</nowiki></code> and <code><nowiki>''italic''</nowiki></code>
|-
| Link (internal) || <code><nowiki>[[Link to an internal page]]</nowiki></code> or <code><nowiki>[[Link|Title of Link]]</nowiki></code>
|-
| Link (external) || <code><nowiki>http://example.com/</nowiki></code> or <code><nowiki>[http://example.org/ Title of Link]</nowiki></code>
|-
| Code decoration in continuous text || <code>&lt;code>document&lt;/code></code>
|-
| Code decoration (blocks) || [[Template:Beispiel]] or <code>&lt;pre>source code&lt;/pre></code>
|-
| Unordered List || <code><nowiki>* HTML</nowiki><br><nowiki>* CSS</nowiki><br><nowiki>* JavaScript</nowiki></code>
|-
| Ordered List || <code><nowiki># one</nowiki><br><nowiki># two</nowiki><br><nowiki>## two.one</nowiki></code>
|-
| Browser icons || <code><nowiki>{{Iconset|ie1.0|op5.12|fx1.0|konq3.1|saf1.0|html2.0|xhtml1.0}}</nowiki></code>, see [[Template:Iconset]]
|-
|colspan=2 id=selfhtml_quick_syntax_examples_lastline|More infos: [[Hilfe:Bearbeitungshilfe]] (Recommendation: use right click to open in new window / tab)
|}
HELP
,
	'selfhtml-sponsor' => '<a href="http://www.ntteuropeonline.de/"><img width="412" height="70" title="Der SELFHTML Hosting-Sponsor: NTT Communications | NTT Europe Online" alt="Der SELFHTML Hosting-Sponsor: NTT Communications | NTT Europe Online" src="$1/selfhtml/ntteologo.gif"></a>',
	'selfhtml-license' => 'Text in the SELFHTML Wiki is available under the [http://creativecommons.org/licenses/by-sa/3.0/de/ CC-BY-SA 3.0 (de)].<br>
See [[SELFHTML-Wiki/Lizenzvereinbarungen]] for details.',
	'skinname-selfhtml' => 'SELFHTML',

	'selfhtml-emff-error-no-file' => '<nowiki>#EMFF:</nowiki> no file name found',
	'selfhtml-emff-error-invalid-file' => '<nowiki>#EMFF:</nowiki> file name is not valid',

	'selfhtml-example-error-no-title' => '<nowiki>#BeispielUrl:</nowiki> title parameter missing',
	'selfhtml-example-error-invalid-namespace' => '<nowiki>#BeispielUrl:</nowiki> invalid namespace for examples',
	'selfhtml-example-linktext' => 'Show',
	'selfhtml-frickl-linktext' => 'fiddle!',
	'selfhtml-viewport-emulator' => 'in viewport emulator',
);

/** Message documentation (Message documentation)
 */
$messages['qqq'] = array(
	'selfhtml-desc' => 'Short description of the SELFHTML extension, shown on [[Special:Version]].',
	'selfhtml-slogan' => 'The slogan of SELFHTML.',
	'selfhtml-edithelp' => 'Additional help to show below the edit form.',
	'selfhtml-sponsor' => 'SELFHTML\'s sponsor',
	'selfhtml-license' => 'To insert in the footer',
	'skinname-selfhtml' => 'SELFHTML',

	'selfhtml-emff-error-no-file' => '{{#EMFF:…}} there was no parameter found that could be tried as a file name',
	'selfhtml-emff-error-invalid-file' => '{{#EMFF:…}} the file name parameter doesn\'t existe as File:…',

	'selfhtml-example-error-no-title' => '{{#BeispielUrl:…}} there was no parameter found that could be tried as a title',
	'selfhtml-example-error-invalid-namespace' => '{{#BeispielUrl:…}} invalid namespace for examples',
	'selfhtml-example-linktext' => 'Linktext for links to examples',
	'selfhtml-frickl-linktext' => 'Linktext for links to a fiddle',
	'selfhtml-viewport-emulator' => 'test example in a viewport emulator',
);

/** German (Deutsch)
 */
$messages['de'] = array(
	'selfhtml-desc' => 'SELFHTML-Extras',
	'selfhtml-slogan' => 'Die Energie des Verstehens',
	'selfhtml-edithelp' => <<<HELP
{| class="selfhtml_quick_syntax_examples"
|+ Beispiele Wiki-Syntax:
! Formatierung !! Beispiel
|-
| Überschrift 2. Ordnung || <code><nowiki>== Titel ==</nowiki></code>
|-
| Überschrift 3. Ordnung || <code><nowiki>=== Titel ===</nowiki></code>
|-
| Fett bzw. kursiv || <code><nowiki>'''fett'''</nowiki></code> bzw. <code><nowiki>''kursiv''</nowiki></code>
|-
| Link (intern) || <code><nowiki>[[Link auf interne Seite]]</nowiki></code> oder <code><nowiki>[[Link|Linktitel]]</nowiki></code>
|-
| Link (extern) || <code><nowiki>http://example.com/</nowiki></code> oder <code><nowiki>[http://example.org/ Linktitel]</nowiki></code>
|-
| Code-Auszeichnung innerhalb Fließtext || <code>&lt;code>document&lt;/code></code>
|-
| Quelltext auszeichnen (Blöcke) || [[Vorlage:Beispiel]] oder <code>&lt;pre>Quelltext&lt;/pre></code>
|-
| Aufzählungsliste || <code><nowiki>* HTML</nowiki><br><nowiki>* CSS</nowiki><br><nowiki>* JavaScript</nowiki></code>
|-
| Nummerierte Liste || <code><nowiki># eins</nowiki><br><nowiki># zwei</nowiki><br><nowiki>## zwei.eins</nowiki></code>
|-
| Browsergrafiken || <code><nowiki>{{Iconset|ie1|op5.12|fx1|konq3.1|saf1.0|html2|xhtml1}}</nowiki></code> siehe [[Vorlage:Iconset]]
|-
|colspan=2 id=selfhtml_quick_syntax_examples_lastline|Weitere Infos: [[Hilfe:Bearbeitungshilfe]] (Empfehlung: mit Rechtsklick in einem neuem Fenster/Tab öffnen)
|}
HELP
,
	'selfhtml-sponsor' => '<a href="http://www.ntteuropeonline.de/"><img width="412" height="70" title="Der SELFHTML Hosting-Sponsor: NTT Communications | NTT Europe Online" alt="Der SELFHTML Hosting-Sponsor: NTT Communications | NTT Europe Online" src="$1/selfhtml/ntteologo.gif"></a>',
	'selfhtml-license' => 'Die Inhalte des SELFHTML-Wikis unterliegen der Lizenz [http://creativecommons.org/licenses/by-sa/3.0/de/ CC-BY-SA 3.0 (de)].<br>
Nähere Informationen finden Sie unter [[SELFHTML-Wiki/Lizenzvereinbarungen]].',
	'skinname-selfhtml' => 'SELFHTML',

	'selfhtml-emff-error-no-file' => '#EMFF: keine Datei angegeben.',
	'selfhtml-emff-error-invalid-file' => '#EMFF: Dateiname ist ungültig.',

	'selfhtml-example-error-no-title' => '#BeispielUrl: Parameter title fehlt.',
	'selfhtml-example-error-invalid-namespace' => '#BeispielUrl: ungültiger Namespace für Beispiele',
	'selfhtml-example-linktext' => 'So sieht\'s aus',
	'selfhtml-frickl-linktext' => 'ausprobieren',
	'selfhtml-viewport-emulator' => 'im Viewport-Emulator',
);
