<?php
/**
 * Internationalisation file for Lingo extension.
 *
 * @file
 * @ingroup Extensions
 */

$magicWords = array();

/** English (English) */
$magicWords[ 'en' ] = array(
	'noglossary' => array( 0, '__NOGLOSSARY__' ),
);

/** Arabic (العربية) */
$magicWords[ 'ar' ] = array(
	'noglossary' => array( 0, '__لا_قاموس__' ),
);

/** Egyptian Arabic (مصرى) */
$magicWords[ 'arz' ] = array(
	'noglossary' => array( 0, '__من_غير_قاموس__' ),
);

/** German (Deutsch) */
$magicWords[ 'de' ] = array(
	'noglossary' => array( 0, '__KEINGLOSSAR__', '__KEIN_GLOSSAR__' ),
);

/** Zazaki (Zazaki) */
$magicWords[ 'diq' ] = array(
	'noglossary' => array( 0, 'QISEBENDÇINİYO' ),
);

/** Esperanto (Esperanto) */
$magicWords[ 'eo' ] = array(
	'noglossary' => array( 0, '__NEDIFINO__' ),
);

/** French (français) */
$magicWords[ 'fr' ] = array(
	'noglossary' => array( 0, '__SANSGLOSSAIRE__' ),
);

/** Italian (italiano) */
$magicWords[ 'it' ] = array(
	'noglossary' => array( 0, '__NOGLOSSARIO__' ),
);

/** Korean (한국어) */
$magicWords[ 'ko' ] = array(
	'noglossary' => array( 0, '__용어집없음__' ),
);

/** Macedonian (македонски) */
$magicWords[ 'mk' ] = array(
	'noglossary' => array( 0, '__БЕЗПОИМНИК__' ),
);

/** Malayalam (മലയാളം) */
$magicWords[ 'ml' ] = array(
	'noglossary' => array( 0, '__ചുരുക്കംവേണ്ട__' ),
);

/** Low Saxon (Netherlands) (Nedersaksies) */
$magicWords[ 'nds-nl' ] = array(
	'noglossary' => array( 0, '__GIEN_GLOSSARIUM__' ),
);

/** Dutch (Nederlands) */
$magicWords[ 'nl' ] = array(
	'noglossary' => array( 0, '___GEENWOORDENLIJST__' ),
);

/** Serbian (Latin script) (srpski (latinica)‎) */
$magicWords[ 'sr-el' ] = array(
	'noglossary' => array( 0, '__BEZREČNIKA__', '__BEZ_REČNIKA__' ),
);

/** Turkish (Türkçe) */
$magicWords[ 'tr' ] = array(
	'noglossary' => array( 0, '__SÖZLÜKYOK__' ),
);

/** Simplified Chinese (中文（简体）‎) */
$magicWords[ 'zh-hans' ] = array(
	'noglossary' => array( 0, '__无词汇表__' ),
);
