<?php
# This file was automatically generated by the MediaWiki 1.27.2
# installer. If you make manual changes, please keep track in case you
# need to recreate them later.
#
# See includes/DefaultSettings.php for all configurable settings
# and their default values, but don't forget to make changes in _this_
# file, not there.
#
# Further documentation for configuration settings may be found at:
# https://www.mediawiki.org/wiki/Manual:Configuration_settings

# Protect against web entry
if ( !defined( 'MEDIAWIKI' ) ) {
	exit;
}

$pdn = $_SERVER['HTTP_HOST'];

## Uncomment this to disable output compression
# $wgDisableOutputCompression = true;

$wgSitename = "SELFHTML-Wiki";
$wgMetaNamespace = "SELFHTML";
$wgMetaNamespaceTalk = 'SELFHTML_Diskussion';

## The URL base path to the directory containing the wiki;
## defaults for all runtime URL paths are based off of this.
## For more information on customizing the URLs
## (like /w/index.php/Page_title to /wiki/Page_title) please see:
## https://www.mediawiki.org/wiki/Manual:Short_URL
$wgScriptPath = '';
$wgArticlePath = "/index.php?title=$1";
#$wgUsePathInfo = true;

## The protocol and server name to use in fully-qualified URLs
$wgServer = "//$pdn";
$wgCanonicalServer = "http://$pdn";

## The URL path to static resources (images, scripts, etc.)
$wgResourceBasePath = $wgScriptPath;

## The URL path to the logo.  Make sure you change this from the default,
## or else you'll overwrite your logo when you upgrade!
##$wgLogo = "$wgResourceBasePath/resources/assets/wiki.png";
$wgLogo = "skins/Selfhtml/images/selfhtml-q-logo-wiki.png";
$wgFavicon = "//$pdn/skins/Selfhtml/images/favicon2.ico";

## UPO means: this is also a user preference option

$wgEnableEmail = false;
$wgEnableUserEmail = false; # UPO

$wgEmergencyContact = "server@$pdn";
$wgPasswordSender = "server@$pdn";
$wgPasswordSenderName = "SELFHTML Wiki";

$wgEnotifUserTalk = false; # UPO
$wgEnotifWatchlist = false; # UPO
$wgEmailAuthentication = true;

## Database settings
$wgDBtype = "sqlite";
$wgDBserver = "";
$wgDBname = "wiki";
$wgDBuser = "";
$wgDBpassword = "";
$wgSQLiteDataDir = "$IP/data";
$wgObjectCaches[CACHE_DB] = [
	'class' => 'SqlBagOStuff',
	'loggroup' => 'SQLBagOStuff',
	'server' => [
		'type' => 'sqlite',
		'dbname' => 'wikicache',
		'tablePrefix' => '',
		'flags' => 0
	]
];

## Shared memory settings
$wgMainCacheType = CACHE_NONE;
$wgParserCacheType = CACHE_NONE;
$wgMessageCacheType = CACHE_NONE;

$wgUseFileCache = true;
$wgFileCacheDirectory = "$IP/cache";

## To enable image uploads, make sure the 'images' directory
## is writable, then set this to true:
$wgEnableUploads = false;
$wgUseImageMagick = false;
#$wgImageMagickConvertCommand = "/usr/bin/convert";

# InstantCommons allows wiki to use images from https://commons.wikimedia.org
$wgUseInstantCommons = false;

## If you use ImageMagick (or any other shell command) on a
## Linux server, this will need to be set to the name of an
## available UTF-8 locale
$wgShellLocale = "en_US.utf8";

## Set $wgCacheDirectory to a writable directory on the web server
## to make your wiki go slightly faster. The directory should not
## be publically accessible from the web.
$wgCacheDirectory = "$IP/cache";
$wgTmpDirectory = "$IP/cache";

# Site language code, should be one of the list in ./languages/data/Names.php
$wgLanguageCode = "de-formal";

$wgSecretKey = "8744a678db66436b6d7c9604c89b41b726846bc23ff533b06a28abcb789637ec";

# Changing this will log out all existing sessions.
$wgAuthenticationTokenVersion = "1";

# Site upgrade key. Must be set to a string (default provided) to turn on the
# web installer while LocalSettings.php is in place
$wgUpgradeKey = "b8dfc909a6b58494";

## For attaching licensing metadata to pages, and displaying an
## appropriate copyright notice / icon. GNU Free Documentation
## License and Creative Commons licenses are supported so far.
$wgRightsPage = ''; # Set to the title of a wiki page that describes your license/copyright
$wgRightsUrl = 'http://creativecommons.org/licenses/by-sa/3.0/de/';
$wgRightsText = 'CC-BY-SA 3.0 (de)';
$wgRightsIcon = "//$pdn/resources/assets/licenses/cc-by-sa.png";

# Path to the GNU diff3 utility. Used for conflict resolution.
$wgDiff3 = '/usr/bin/diff3';

## Default skin: you can change the default skin. Use the internal symbolic
## names, ie 'vector', 'monobook':
$wgDefaultSkin = 'vector';
$wgDefaultSkin = 'selfhtml';

# Enabled skins.
# The following skins were automatically enabled:
#wfLoadSkin( 'CologneBlue' );
#wfLoadSkin( 'Modern' );
#wfLoadSkin( 'MonoBook' );
wfLoadSkin( 'Vector' );
wfLoadSkin( 'Selfhtml' );

# Enabled extensions. Most of the extensions are enabled by adding
# wfLoadExtensions('ExtensionName');
# to LocalSettings.php. Check specific extension documentation for more details.
# The following extensions were automatically enabled:
wfLoadExtension( 'Cite' );
#wfLoadExtension( 'CiteThisPage' );
wfLoadExtensions([ 'ConfirmEdit', 'ConfirmEdit/ReCaptchaNoCaptcha' ]);
wfLoadExtension( 'Gadgets' );
wfLoadExtension( 'ImageMap' );
wfLoadExtension( 'InputBox' );
wfLoadExtension( 'Interwiki' );
#wfLoadExtension( 'Lingo' );
wfLoadExtension( 'LocalisationUpdate' );
wfLoadExtension( 'Nuke' );
wfLoadExtension( 'ParserFunctions' );
$wgPFEnableStringFunctions = true;
#wfLoadExtension( 'PdfHandler' );
wfLoadExtension( 'Renameuser' );
require_once "$IP/extensions/SemanticCompoundQueries/SemanticCompoundQueries.php";
wfLoadExtension( 'SemanticGlossary' );
require_once "$IP/extensions/SemanticMediaWiki/SemanticMediaWiki.php";
require_once "$IP/extensions/SemanticResultFormats/SemanticResultFormats.php";
wfLoadExtension( 'SpamBlacklist' );
wfLoadExtension( 'SyntaxHighlight_GeSHi' );
wfLoadExtension( 'TitleBlacklist' );
wfLoadExtension( 'WikiEditor' );


# End of automatically generated settings.
# Add more configuration options below.

# Timezone
$wgLocaltimezone = 'Europe/Berlin';
$oldtz = getenv('TZ');
putenv('TZ=' . $wgLocaltimezone);
$wgLocalTZoffset = date('Z') / 60;
putenv('TZ=' . $oldtz);

$wgAllowUserCss = true;
$wgAllowUserJs = true;

# Suppress display of markup in the search results (doesn't work for all markup)
$wgAdvancedSearchHighlighting = true;

$wgFileExtensions = array_merge($wgFileExtensions, array('mp3', 'cur', 'svg'));

# Anonymous edits but no page creation
$wgGroupPermissions['*']['createaccount'] = false;
$wgGroupPermissions['*']['edit'] = false;
$wgGroupPermissions['*']['read'] = true;

// geschützte Namespaces dazu siehe am Ende der Namespace-Konfigurationen
$wgGroupPermissions['exampleadmin']['editexample'] = true;

# #############################################
# #             Namespaces                    #
# #############################################
# NS SELFHTML entsteht durch $wgMetaNamespace bzw. $wgSitename
define('NS_DOKU', 100);
define('NS_DOKU_TALK', 101);
define('NS_BEISPIEL', 102);
define('NS_BEISPIEL_TALK', 103);
define('NS_KURSE',110);
define('NS_KURSE_TALK',111);
define('NS_REFERENZ',120);
define('NS_REFERENZEN',120); # Alias
define('NS_REFERENZ_TALK',121);
define('NS_REFERENZEN_TALK',121); # Alias
define('NS_THEMEN',130);
define('NS_THEMEN_TALK',131);
define('NS_ARTIKEL',140);
define('NS_ARTIKEL_TALK',141);
#define('NS_EXTRAS',150);
#define('NS_EXTRAS_TALK',151);
#define('NS_VEREIN',160);
#define('NS_VEREIN_TALK',161);
#define('NS_COMMUNITY',170);
#define('NS_COMMUNITY_TALK',171);
define('NS_GLOSSAR',180);
define('NS_GLOSSAR_TALK',181);
define('NS_ARCHIV',190);
define('NS_ARCHIV_TALK',191);
# 200..209 reserved for Semantic MediaWiki

$wgExtraNamespaces =
array(
	NS_DOKU => 'Doku',
	NS_DOKU_TALK => 'Doku_Diskussion',
	NS_BEISPIEL => 'Beispiel',
	NS_BEISPIEL_TALK => 'Beispiel_Diskussion',
	NS_KURSE => 'Kurse',
	NS_KURSE_TALK => 'Kurse_Diskussion',
	NS_REFERENZ => 'Referenz',
	NS_REFERENZ_TALK => 'Referenz_Diskussion',
	NS_THEMEN => 'Themen',
	NS_THEMEN_TALK => 'Themen_Diskussion',
	NS_ARTIKEL => 'Artikel',
	NS_ARTIKEL_TALK => 'Artikel_Diskussion',
#	NS_EXTRAS => 'Extras',
#	NS_EXTRAS_TALK => 'Extras_Diskussionen',
#	NS_VEREIN => 'Verein',
#	NS_VEREIN_TALK => 'Verein_Diskussion',
#	NS_COMMUNITY => 'Community',
#	NS_COMMUNITY_TALK => 'Community_Diskussion',
	NS_GLOSSAR => 'Glossar',
	NS_GLOSSAR_TALK => 'Glossar_Diskussion',
	NS_ARCHIV => 'Archiv',
	NS_ARCHIV_TALK => 'Archiv_Diskussion',
);

$wgNamespaceAliases = array(
	'Referenzen' => NS_REFERENZ,
	'Referenzen_Diskussion' => NS_REFERENZ_TALK,
);

$wgContentNamespaces = array(NS_MAIN, NS_DOKU, NS_KURSE, NS_REFERENZ, NS_THEMEN, NS_ARTIKEL, NS_GLOSSAR, NS_ARCHIV);
// NS_EXTRAS, NS_VEREIN and NS_COMMUNITY entfernt, nicht verwendet. Ersatz-NS: SELFHTML
$wgNamespacesToBeSearchedDefault = array_fill_keys($wgContentNamespaces, true);
# Enable subpages in all namespaces
$wgNamespacesWithSubpages = array_fill(0, 300, true);

# Namespaces für Beispiel-Code
$egExampleNamespaces = array(NS_BEISPIEL);

# Namespace-Berechtigungen
$wgNamespaceProtection = array_fill_keys($egExampleNamespaces, array('editexample'));

# CategoryTree
require_once "$IP/extensions/CategoryTree/CategoryTree.php";

# CharInsert
wfLoadExtension( 'CharInsert' );

# Variables & Loop
require_once "$IP/extensions/Variables/Variables.php";
require_once "$IP/extensions/Loops/Loops.php";

# SELFHTML
require_once "$IP/extensions/Selfhtml/SELFHTML.php";

# TitleKey - case-insensitive title prefix search plugin
require_once "$IP/extensions/TitleKey/TitleKey.php";

# ConfirmEdit
#now bundled require_once "$IP/extensions/ConfirmEdit/ConfirmEdit.php";
#require_once "$IP/extensions/ConfirmEdit/MathCaptcha.php";
$wgCaptchaClass = 'SimpleCaptcha';
$wgCaptchaTriggers['edit'] = false;
$wgCaptchaTriggers['create'] = false;
$wgCaptchaTriggers['addurl'] = true;
$wgCaptchaTriggers['createaccount'] = true;
$wgCaptchaTriggers['badlogin'] = false;

$wgGroupPermissions['*'            ]['skipcaptcha'] = false;
$wgGroupPermissions['user'         ]['skipcaptcha'] = false;
$wgGroupPermissions['autoconfirmed']['skipcaptcha'] = true;
$wgGroupPermissions['bot'          ]['skipcaptcha'] = true; // registered bots
$wgGroupPermissions['sysop'        ]['skipcaptcha'] = true;

$wgAutoConfirmAge = 3 * 24 * 60 * 60;
$wgAutoConfirmCount = 20;

# UserMerge
wfLoadExtension( 'UserMerge' );
// By default nobody can use this function, enable for bureaucrat?
$wgGroupPermissions['bureaucrat']['usermerge'] = true;
// optional: default is array( 'sysop' )
#$wgUserMergeProtectedGroups = array( 'groupname' );

# TitleBlacklist
wfLoadExtension( 'TitleBlacklist' );

# SpamBlacklist
wfLoadExtension( 'SpamBlacklist' );

# Semantic MediaWiki
#require_once "$IP/extensions/Validator/Validator.php";
$smwgNamespaceIndex = 200;
enableSemantics("$pdn");
#require_once "$IP/extensions/SemanticInternalObjects/SemanticInternalObjects.php";
#require_once "$IP/extensions/SemanticForms/SemanticForms.php";

# Debugging etc.
$wgStyleVersion += 2;

$wgResourceLoaderDebug = false;
$wgShowExceptionDetails = true;
#$wgDebugToolbar = true;
#$wgShowDebug = true;

unset($pdn);

$wgReadOnly = 'Dieses Wiki ist eine nicht bearbeitbare Offline-Version.';

#error_reporting( -1 );
#ini_set( 'display_startup_errors', 1 );
#ini_set( 'display_errors', 1 );
